/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.firestore.streamhandler;

import android.os.Handler;
import android.os.Looper;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.SetOptions;
import com.google.firebase.firestore.Transaction;
import com.google.firebase.firestore.TransactionOptions;
import io.flutter.plugin.common.EventChannel;
import io.flutter.plugins.firebase.firestore.FlutterFirebaseFirestoreTransactionResult;
import io.flutter.plugins.firebase.firestore.GeneratedAndroidFirebaseFirestore;
import io.flutter.plugins.firebase.firestore.streamhandler.OnTransactionResultListener;
import io.flutter.plugins.firebase.firestore.utils.ExceptionConverter;
import io.flutter.plugins.firebase.firestore.utils.PigeonParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class TransactionStreamHandler
implements OnTransactionResultListener,
EventChannel.StreamHandler {
    final OnTransactionStartedListener onTransactionStartedListener;
    final FirebaseFirestore firestore;
    final String transactionId;
    final Long timeout;
    final Long maxAttempts;
    final Semaphore semaphore = new Semaphore(0);
    private GeneratedAndroidFirebaseFirestore.PigeonTransactionResult resultType;
    private List<GeneratedAndroidFirebaseFirestore.PigeonTransactionCommand> commands;
    final Handler mainLooper = new Handler(Looper.getMainLooper());

    public TransactionStreamHandler(OnTransactionStartedListener onTransactionStartedListener, FirebaseFirestore firestore, String transactionId, Long timeout, Long maxAttempts) {
        this.onTransactionStartedListener = onTransactionStartedListener;
        this.firestore = firestore;
        this.transactionId = transactionId;
        this.timeout = timeout;
        this.maxAttempts = maxAttempts;
    }

    public void onListen(Object arguments, EventChannel.EventSink events) {
        this.firestore.runTransaction(new TransactionOptions.Builder().setMaxAttempts(this.maxAttempts.intValue()).build(), transaction -> {
            this.onTransactionStartedListener.onStarted(transaction);
            HashMap<String, String> attemptMap = new HashMap<String, String>();
            attemptMap.put("appName", this.firestore.getApp().getName());
            this.mainLooper.post(() -> events.success((Object)attemptMap));
            try {
                if (!this.semaphore.tryAcquire(this.timeout, TimeUnit.MILLISECONDS)) {
                    return FlutterFirebaseFirestoreTransactionResult.failed((Exception)new FirebaseFirestoreException("timed out", FirebaseFirestoreException.Code.DEADLINE_EXCEEDED));
                }
            }
            catch (InterruptedException e) {
                return FlutterFirebaseFirestoreTransactionResult.failed((Exception)new FirebaseFirestoreException("interrupted", FirebaseFirestoreException.Code.DEADLINE_EXCEEDED));
            }
            if (this.commands.isEmpty()) {
                return FlutterFirebaseFirestoreTransactionResult.complete();
            }
            if (this.resultType == GeneratedAndroidFirebaseFirestore.PigeonTransactionResult.FAILURE) {
                return FlutterFirebaseFirestoreTransactionResult.complete();
            }
            for (GeneratedAndroidFirebaseFirestore.PigeonTransactionCommand command : this.commands) {
                DocumentReference documentReference = this.firestore.document(command.getPath());
                switch (command.getType()) {
                    case DELETE_TYPE: {
                        transaction.delete(documentReference);
                        break;
                    }
                    case UPDATE: {
                        transaction.update(documentReference, Objects.requireNonNull(command.getData()));
                        break;
                    }
                    case SET: {
                        GeneratedAndroidFirebaseFirestore.PigeonDocumentOption options = Objects.requireNonNull(command.getOption());
                        SetOptions setOptions = null;
                        if (options.getMerge() != null && options.getMerge().booleanValue()) {
                            setOptions = SetOptions.merge();
                        } else if (options.getMergeFields() != null) {
                            List<List<String>> fieldList = Objects.requireNonNull(options.getMergeFields());
                            List<FieldPath> fieldPathList = PigeonParser.parseFieldPath(fieldList);
                            setOptions = SetOptions.mergeFieldPaths(fieldPathList);
                        }
                        Map<String, Object> data = Objects.requireNonNull(command.getData());
                        if (setOptions == null) {
                            transaction.set(documentReference, data);
                            break;
                        }
                        transaction.set(documentReference, data, setOptions);
                        break;
                    }
                }
            }
            return FlutterFirebaseFirestoreTransactionResult.complete();
        }).addOnCompleteListener(task -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (task.getException() != null || ((FlutterFirebaseFirestoreTransactionResult)task.getResult()).exception != null) {
                Exception exception = task.getException() != null ? task.getException() : ((FlutterFirebaseFirestoreTransactionResult)task.getResult()).exception;
                map.put("appName", this.firestore.getApp().getName());
                map.put("error", ExceptionConverter.createDetails(exception));
            } else if (task.getResult() != null) {
                map.put("complete", true);
            }
            this.mainLooper.post(() -> {
                events.success((Object)map);
                events.endOfStream();
            });
        });
    }

    public void onCancel(Object arguments) {
        this.semaphore.release();
    }

    @Override
    public void receiveTransactionResponse(GeneratedAndroidFirebaseFirestore.PigeonTransactionResult resultType, List<GeneratedAndroidFirebaseFirestore.PigeonTransactionCommand> commands) {
        this.resultType = resultType;
        this.commands = commands;
        this.semaphore.release();
    }

    public static interface OnTransactionStartedListener {
        public void onStarted(Transaction var1);
    }
}

