/*
 * Decompiled with CFR 0.152.
 */
package com.baseflow.permissionhandler;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.app.ActivityCompat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class PermissionUtils {
    static final String SHARED_PREFERENCES_PERMISSION_WAS_DENIED_BEFORE_KEY = "sp_permission_handler_permission_was_denied_before";

    static int parseManifestName(String permission2) {
        switch (permission2) {
            case "android.permission.WRITE_CALENDAR": 
            case "android.permission.READ_CALENDAR": {
                return 0;
            }
            case "android.permission.CAMERA": {
                return 1;
            }
            case "android.permission.READ_CONTACTS": 
            case "android.permission.WRITE_CONTACTS": 
            case "android.permission.GET_ACCOUNTS": {
                return 2;
            }
            case "android.permission.ACCESS_BACKGROUND_LOCATION": {
                return 4;
            }
            case "android.permission.ACCESS_COARSE_LOCATION": 
            case "android.permission.ACCESS_FINE_LOCATION": {
                return 3;
            }
            case "android.permission.RECORD_AUDIO": {
                return 7;
            }
            case "android.permission.READ_PHONE_STATE": 
            case "android.permission.READ_PHONE_NUMBERS": 
            case "android.permission.CALL_PHONE": 
            case "android.permission.READ_CALL_LOG": 
            case "android.permission.WRITE_CALL_LOG": 
            case "com.android.voicemail.permission.ADD_VOICEMAIL": 
            case "android.permission.USE_SIP": {
                return 8;
            }
            case "android.permission.BODY_SENSORS": {
                return 12;
            }
            case "android.permission.BODY_SENSORS_BACKGROUND": {
                return 35;
            }
            case "android.permission.SEND_SMS": 
            case "android.permission.RECEIVE_SMS": 
            case "android.permission.READ_SMS": 
            case "android.permission.RECEIVE_WAP_PUSH": 
            case "android.permission.RECEIVE_MMS": {
                return 13;
            }
            case "android.permission.READ_EXTERNAL_STORAGE": 
            case "android.permission.WRITE_EXTERNAL_STORAGE": {
                return 15;
            }
            case "android.permission.ACCESS_MEDIA_LOCATION": {
                return 18;
            }
            case "android.permission.ACTIVITY_RECOGNITION": {
                return 19;
            }
            case "android.permission.MANAGE_EXTERNAL_STORAGE": {
                return 22;
            }
            case "android.permission.SYSTEM_ALERT_WINDOW": {
                return 23;
            }
            case "android.permission.REQUEST_INSTALL_PACKAGES": {
                return 24;
            }
            case "android.permission.ACCESS_NOTIFICATION_POLICY": {
                return 27;
            }
            case "android.permission.BLUETOOTH_SCAN": {
                return 28;
            }
            case "android.permission.BLUETOOTH_ADVERTISE": {
                return 29;
            }
            case "android.permission.BLUETOOTH_CONNECT": {
                return 30;
            }
            case "android.permission.POST_NOTIFICATIONS": {
                return 17;
            }
            case "android.permission.NEARBY_WIFI_DEVICES": {
                return 31;
            }
            case "android.permission.READ_MEDIA_IMAGES": {
                return 9;
            }
            case "android.permission.READ_MEDIA_VIDEO": {
                return 32;
            }
            case "android.permission.READ_MEDIA_AUDIO": {
                return 33;
            }
            case "android.permission.SCHEDULE_EXACT_ALARM": {
                return 34;
            }
        }
        return 20;
    }

    @TargetApi(value=22)
    static List<String> getManifestNames(Context context, int permission2) {
        ArrayList<String> permissionNames = new ArrayList<String>();
        switch (permission2) {
            case 36: {
                if (!PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.WRITE_CALENDAR")) break;
                permissionNames.add("android.permission.WRITE_CALENDAR");
                break;
            }
            case 0: 
            case 37: {
                if (PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.WRITE_CALENDAR")) {
                    permissionNames.add("android.permission.WRITE_CALENDAR");
                }
                if (!PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.READ_CALENDAR")) break;
                permissionNames.add("android.permission.READ_CALENDAR");
                break;
            }
            case 1: {
                if (!PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.CAMERA")) break;
                permissionNames.add("android.permission.CAMERA");
                break;
            }
            case 2: {
                if (PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.READ_CONTACTS")) {
                    permissionNames.add("android.permission.READ_CONTACTS");
                }
                if (PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.WRITE_CONTACTS")) {
                    permissionNames.add("android.permission.WRITE_CONTACTS");
                }
                if (!PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.GET_ACCOUNTS")) break;
                permissionNames.add("android.permission.GET_ACCOUNTS");
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                if (permission2 == 4 && Build.VERSION.SDK_INT >= 29) {
                    if (!PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.ACCESS_BACKGROUND_LOCATION")) break;
                    permissionNames.add("android.permission.ACCESS_BACKGROUND_LOCATION");
                    break;
                }
                if (PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.ACCESS_COARSE_LOCATION")) {
                    permissionNames.add("android.permission.ACCESS_COARSE_LOCATION");
                }
                if (!PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.ACCESS_FINE_LOCATION")) break;
                permissionNames.add("android.permission.ACCESS_FINE_LOCATION");
                break;
            }
            case 7: 
            case 14: {
                if (!PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.RECORD_AUDIO")) break;
                permissionNames.add("android.permission.RECORD_AUDIO");
                break;
            }
            case 8: {
                if (PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.READ_PHONE_STATE")) {
                    permissionNames.add("android.permission.READ_PHONE_STATE");
                }
                if (Build.VERSION.SDK_INT > 29 && PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.READ_PHONE_NUMBERS")) {
                    permissionNames.add("android.permission.READ_PHONE_NUMBERS");
                }
                if (PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.CALL_PHONE")) {
                    permissionNames.add("android.permission.CALL_PHONE");
                }
                if (PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.READ_CALL_LOG")) {
                    permissionNames.add("android.permission.READ_CALL_LOG");
                }
                if (PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.WRITE_CALL_LOG")) {
                    permissionNames.add("android.permission.WRITE_CALL_LOG");
                }
                if (PermissionUtils.hasPermissionInManifest(context, permissionNames, "com.android.voicemail.permission.ADD_VOICEMAIL")) {
                    permissionNames.add("com.android.voicemail.permission.ADD_VOICEMAIL");
                }
                if (PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.USE_SIP")) {
                    permissionNames.add("android.permission.USE_SIP");
                }
                if (Build.VERSION.SDK_INT < 26 || !PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.ANSWER_PHONE_CALLS")) break;
                permissionNames.add("android.permission.ANSWER_PHONE_CALLS");
                break;
            }
            case 12: {
                if (Build.VERSION.SDK_INT < 20 || !PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.BODY_SENSORS")) break;
                permissionNames.add("android.permission.BODY_SENSORS");
                break;
            }
            case 35: {
                if (Build.VERSION.SDK_INT < 33 || !PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.BODY_SENSORS_BACKGROUND")) break;
                permissionNames.add("android.permission.BODY_SENSORS_BACKGROUND");
                break;
            }
            case 13: {
                if (PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.SEND_SMS")) {
                    permissionNames.add("android.permission.SEND_SMS");
                }
                if (PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.RECEIVE_SMS")) {
                    permissionNames.add("android.permission.RECEIVE_SMS");
                }
                if (PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.READ_SMS")) {
                    permissionNames.add("android.permission.READ_SMS");
                }
                if (PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.RECEIVE_WAP_PUSH")) {
                    permissionNames.add("android.permission.RECEIVE_WAP_PUSH");
                }
                if (!PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.RECEIVE_MMS")) break;
                permissionNames.add("android.permission.RECEIVE_MMS");
                break;
            }
            case 15: {
                if (PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.READ_EXTERNAL_STORAGE")) {
                    permissionNames.add("android.permission.READ_EXTERNAL_STORAGE");
                }
                if (Build.VERSION.SDK_INT >= 29 && (Build.VERSION.SDK_INT != 29 || !Environment.isExternalStorageLegacy()) || !PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.WRITE_EXTERNAL_STORAGE")) break;
                permissionNames.add("android.permission.WRITE_EXTERNAL_STORAGE");
                break;
            }
            case 16: {
                if (Build.VERSION.SDK_INT < 23 || !PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS")) break;
                permissionNames.add("android.permission.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS");
                break;
            }
            case 18: {
                if (Build.VERSION.SDK_INT < 29) {
                    return null;
                }
                if (!PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.ACCESS_MEDIA_LOCATION")) break;
                permissionNames.add("android.permission.ACCESS_MEDIA_LOCATION");
                break;
            }
            case 19: {
                if (Build.VERSION.SDK_INT < 29) {
                    return null;
                }
                if (!PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.ACTIVITY_RECOGNITION")) break;
                permissionNames.add("android.permission.ACTIVITY_RECOGNITION");
                break;
            }
            case 21: {
                if (!PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.BLUETOOTH")) break;
                permissionNames.add("android.permission.BLUETOOTH");
                break;
            }
            case 22: {
                if (Build.VERSION.SDK_INT < 30 || !PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.MANAGE_EXTERNAL_STORAGE")) break;
                permissionNames.add("android.permission.MANAGE_EXTERNAL_STORAGE");
                break;
            }
            case 23: {
                if (!PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.SYSTEM_ALERT_WINDOW")) break;
                permissionNames.add("android.permission.SYSTEM_ALERT_WINDOW");
                break;
            }
            case 24: {
                if (Build.VERSION.SDK_INT < 23 || !PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.REQUEST_INSTALL_PACKAGES")) break;
                permissionNames.add("android.permission.REQUEST_INSTALL_PACKAGES");
                break;
            }
            case 27: {
                if (Build.VERSION.SDK_INT < 23 || !PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.ACCESS_NOTIFICATION_POLICY")) break;
                permissionNames.add("android.permission.ACCESS_NOTIFICATION_POLICY");
                break;
            }
            case 28: {
                String result;
                if (Build.VERSION.SDK_INT < 31 || (result = PermissionUtils.determineBluetoothPermission(context, "android.permission.BLUETOOTH_SCAN")) == null) break;
                permissionNames.add(result);
                break;
            }
            case 29: {
                String result;
                if (Build.VERSION.SDK_INT < 31 || (result = PermissionUtils.determineBluetoothPermission(context, "android.permission.BLUETOOTH_ADVERTISE")) == null) break;
                permissionNames.add(result);
                break;
            }
            case 30: {
                String result;
                if (Build.VERSION.SDK_INT < 31 || (result = PermissionUtils.determineBluetoothPermission(context, "android.permission.BLUETOOTH_CONNECT")) == null) break;
                permissionNames.add(result);
                break;
            }
            case 17: {
                if (Build.VERSION.SDK_INT < 33 || !PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.POST_NOTIFICATIONS")) break;
                permissionNames.add("android.permission.POST_NOTIFICATIONS");
                break;
            }
            case 31: {
                if (Build.VERSION.SDK_INT < 33 || !PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.NEARBY_WIFI_DEVICES")) break;
                permissionNames.add("android.permission.NEARBY_WIFI_DEVICES");
                break;
            }
            case 9: {
                if (Build.VERSION.SDK_INT < 33 || !PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.READ_MEDIA_IMAGES")) break;
                permissionNames.add("android.permission.READ_MEDIA_IMAGES");
                break;
            }
            case 32: {
                if (Build.VERSION.SDK_INT < 33 || !PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.READ_MEDIA_VIDEO")) break;
                permissionNames.add("android.permission.READ_MEDIA_VIDEO");
                break;
            }
            case 33: {
                if (Build.VERSION.SDK_INT < 33 || !PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.READ_MEDIA_AUDIO")) break;
                permissionNames.add("android.permission.READ_MEDIA_AUDIO");
                break;
            }
            case 34: {
                if (!PermissionUtils.hasPermissionInManifest(context, permissionNames, "android.permission.SCHEDULE_EXACT_ALARM")) break;
                permissionNames.add("android.permission.SCHEDULE_EXACT_ALARM");
                break;
            }
            case 6: 
            case 11: 
            case 20: {
                return null;
            }
        }
        return permissionNames;
    }

    private static boolean hasPermissionInManifest(Context context, ArrayList<String> confirmedPermissions, String permission2) {
        try {
            if (confirmedPermissions != null) {
                for (String r : confirmedPermissions) {
                    if (!r.equals(permission2)) continue;
                    return true;
                }
            }
            if (context == null) {
                Log.d((String)"permissions_handler", (String)"Unable to detect current Activity or App Context.");
                return false;
            }
            PackageInfo info = PermissionUtils.getPackageInfo(context);
            if (info == null) {
                Log.d((String)"permissions_handler", (String)"Unable to get Package info, will not be able to determine permissions to request.");
                return false;
            }
            confirmedPermissions = new ArrayList<String>(Arrays.asList(info.requestedPermissions));
            for (String r : confirmedPermissions) {
                if (!r.equals(permission2)) continue;
                return true;
            }
        }
        catch (Exception ex) {
            Log.d((String)"permissions_handler", (String)"Unable to check manifest for permission: ", (Throwable)ex);
        }
        return false;
    }

    static int toPermissionStatus(@Nullable Activity activity, String permissionName, int grantResult) {
        if (grantResult == -1) {
            return PermissionUtils.determineDeniedVariant(activity, permissionName);
        }
        return 1;
    }

    @NonNull
    static Integer strictestStatus(@NonNull Collection<Integer> statuses) {
        if (statuses.contains(4)) {
            return 4;
        }
        if (statuses.contains(2)) {
            return 2;
        }
        if (statuses.contains(0)) {
            return 0;
        }
        if (statuses.contains(3)) {
            return 3;
        }
        return 1;
    }

    @NonNull
    static Integer strictestStatus(@Nullable Integer statusA, @Nullable Integer statusB) {
        HashSet<Integer> statuses = new HashSet<Integer>();
        statuses.add(statusA);
        statuses.add(statusB);
        return PermissionUtils.strictestStatus(statuses);
    }

    static int determineDeniedVariant(@Nullable Activity activity, String permissionName) {
        boolean isDenied;
        boolean shouldShowRational;
        if (activity == null) {
            return 0;
        }
        if (Build.VERSION.SDK_INT < 23) {
            return 0;
        }
        boolean wasDeniedBefore = PermissionUtils.wasPermissionDeniedBefore((Context)activity, permissionName);
        boolean bl = shouldShowRational = !PermissionUtils.isNeverAskAgainSelected(activity, permissionName);
        boolean bl2 = wasDeniedBefore ? !shouldShowRational : (isDenied = shouldShowRational);
        if (!wasDeniedBefore && isDenied) {
            PermissionUtils.setPermissionDenied((Context)activity, permissionName);
        }
        if (wasDeniedBefore && isDenied) {
            return 4;
        }
        return 0;
    }

    @RequiresApi(api=23)
    static boolean isNeverAskAgainSelected(@NonNull Activity activity, String name) {
        boolean shouldShowRequestPermissionRationale = ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)name);
        return !shouldShowRequestPermissionRationale;
    }

    private static String determineBluetoothPermission(Context context, String permission2) {
        if (Build.VERSION.SDK_INT >= 31 && PermissionUtils.hasPermissionInManifest(context, null, permission2)) {
            return permission2;
        }
        if (Build.VERSION.SDK_INT < 29) {
            if (PermissionUtils.hasPermissionInManifest(context, null, "android.permission.ACCESS_FINE_LOCATION")) {
                return "android.permission.ACCESS_FINE_LOCATION";
            }
            if (PermissionUtils.hasPermissionInManifest(context, null, "android.permission.ACCESS_COARSE_LOCATION")) {
                return "android.permission.ACCESS_COARSE_LOCATION";
            }
            return null;
        }
        if (PermissionUtils.hasPermissionInManifest(context, null, "android.permission.ACCESS_FINE_LOCATION")) {
            return "android.permission.ACCESS_FINE_LOCATION";
        }
        return null;
    }

    private static PackageInfo getPackageInfo(Context context) throws PackageManager.NameNotFoundException {
        PackageManager pm = context.getPackageManager();
        if (Build.VERSION.SDK_INT >= 33) {
            return pm.getPackageInfo(context.getPackageName(), PackageManager.PackageInfoFlags.of((long)4096L));
        }
        return pm.getPackageInfo(context.getPackageName(), 4096);
    }

    private static boolean wasPermissionDeniedBefore(Context context, String permissionName) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(permissionName, 0);
        return sharedPreferences.getBoolean(SHARED_PREFERENCES_PERMISSION_WAS_DENIED_BEFORE_KEY, false);
    }

    private static void setPermissionDenied(Context context, String permissionName) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(permissionName, 0);
        sharedPreferences.edit().putBoolean(SHARED_PREFERENCES_PERMISSION_WAS_DENIED_BEFORE_KEY, true).apply();
    }
}

