/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.firestore.utils;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.firestore.AggregateSource;
import com.google.firebase.firestore.DocumentChange;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.Filter;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.ListenSource;
import com.google.firebase.firestore.Query;
import com.google.firebase.firestore.QuerySnapshot;
import com.google.firebase.firestore.SnapshotMetadata;
import com.google.firebase.firestore.Source;
import io.flutter.plugins.firebase.firestore.GeneratedAndroidFirebaseFirestore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PigeonParser {
    public static Source parsePigeonSource(GeneratedAndroidFirebaseFirestore.Source source) {
        switch (source) {
            case CACHE: {
                return Source.CACHE;
            }
            case SERVER_AND_CACHE: {
                return Source.DEFAULT;
            }
            case SERVER: {
                return Source.SERVER;
            }
        }
        throw new IllegalArgumentException("Unknown source: " + (Object)((Object)source));
    }

    public static DocumentSnapshot.ServerTimestampBehavior parsePigeonServerTimestampBehavior(@Nullable GeneratedAndroidFirebaseFirestore.ServerTimestampBehavior serverTimestampBehavior) {
        if (serverTimestampBehavior == null) {
            return DocumentSnapshot.ServerTimestampBehavior.NONE;
        }
        switch (serverTimestampBehavior) {
            case NONE: {
                return DocumentSnapshot.ServerTimestampBehavior.NONE;
            }
            case ESTIMATE: {
                return DocumentSnapshot.ServerTimestampBehavior.ESTIMATE;
            }
            case PREVIOUS: {
                return DocumentSnapshot.ServerTimestampBehavior.PREVIOUS;
            }
        }
        throw new IllegalArgumentException("Unknown server timestamp behavior: " + (Object)((Object)serverTimestampBehavior));
    }

    public static GeneratedAndroidFirebaseFirestore.PigeonQuerySnapshot toPigeonQuerySnapshot(QuerySnapshot querySnapshot, DocumentSnapshot.ServerTimestampBehavior serverTimestampBehavior) {
        GeneratedAndroidFirebaseFirestore.PigeonQuerySnapshot.Builder pigeonQuerySnapshot = new GeneratedAndroidFirebaseFirestore.PigeonQuerySnapshot.Builder();
        pigeonQuerySnapshot.setMetadata(PigeonParser.toPigeonSnapshotMetadata(querySnapshot.getMetadata()));
        pigeonQuerySnapshot.setDocumentChanges(PigeonParser.toPigeonDocumentChanges(querySnapshot.getDocumentChanges(), serverTimestampBehavior));
        pigeonQuerySnapshot.setDocuments(PigeonParser.toPigeonDocumentSnapshots(querySnapshot.getDocuments(), serverTimestampBehavior));
        return pigeonQuerySnapshot.build();
    }

    public static GeneratedAndroidFirebaseFirestore.PigeonSnapshotMetadata toPigeonSnapshotMetadata(SnapshotMetadata snapshotMetadata) {
        GeneratedAndroidFirebaseFirestore.PigeonSnapshotMetadata.Builder pigeonSnapshotMetadata = new GeneratedAndroidFirebaseFirestore.PigeonSnapshotMetadata.Builder();
        pigeonSnapshotMetadata.setHasPendingWrites(snapshotMetadata.hasPendingWrites());
        pigeonSnapshotMetadata.setIsFromCache(snapshotMetadata.isFromCache());
        return pigeonSnapshotMetadata.build();
    }

    public static List<GeneratedAndroidFirebaseFirestore.PigeonDocumentChange> toPigeonDocumentChanges(List<DocumentChange> documentChanges, DocumentSnapshot.ServerTimestampBehavior serverTimestampBehavior) {
        ArrayList<GeneratedAndroidFirebaseFirestore.PigeonDocumentChange> pigeonDocumentChanges = new ArrayList<GeneratedAndroidFirebaseFirestore.PigeonDocumentChange>(documentChanges.size());
        for (DocumentChange documentChange : documentChanges) {
            pigeonDocumentChanges.add(PigeonParser.toPigeonDocumentChange(documentChange, serverTimestampBehavior));
        }
        return pigeonDocumentChanges;
    }

    public static GeneratedAndroidFirebaseFirestore.PigeonDocumentChange toPigeonDocumentChange(DocumentChange documentChange, DocumentSnapshot.ServerTimestampBehavior serverTimestampBehavior) {
        GeneratedAndroidFirebaseFirestore.PigeonDocumentChange.Builder pigeonDocumentChange = new GeneratedAndroidFirebaseFirestore.PigeonDocumentChange.Builder();
        pigeonDocumentChange.setType(PigeonParser.toPigeonDocumentChangeType(documentChange.getType()));
        pigeonDocumentChange.setOldIndex(Long.valueOf(documentChange.getOldIndex()));
        pigeonDocumentChange.setNewIndex(Long.valueOf(documentChange.getNewIndex()));
        pigeonDocumentChange.setDocument(PigeonParser.toPigeonDocumentSnapshot((DocumentSnapshot)documentChange.getDocument(), serverTimestampBehavior));
        return pigeonDocumentChange.build();
    }

    public static GeneratedAndroidFirebaseFirestore.DocumentChangeType toPigeonDocumentChangeType(DocumentChange.Type type) {
        switch (type) {
            case ADDED: {
                return GeneratedAndroidFirebaseFirestore.DocumentChangeType.ADDED;
            }
            case MODIFIED: {
                return GeneratedAndroidFirebaseFirestore.DocumentChangeType.MODIFIED;
            }
            case REMOVED: {
                return GeneratedAndroidFirebaseFirestore.DocumentChangeType.REMOVED;
            }
        }
        throw new IllegalArgumentException("Unknown change type: " + type);
    }

    public static ListenSource parseListenSource(GeneratedAndroidFirebaseFirestore.ListenSource source) {
        switch (source) {
            case DEFAULT_SOURCE: {
                return ListenSource.DEFAULT;
            }
            case CACHE: {
                return ListenSource.CACHE;
            }
        }
        throw new IllegalArgumentException("Unknown ListenSource value: " + (Object)((Object)source));
    }

    public static GeneratedAndroidFirebaseFirestore.PigeonDocumentSnapshot toPigeonDocumentSnapshot(DocumentSnapshot documentSnapshot, DocumentSnapshot.ServerTimestampBehavior serverTimestampBehavior) {
        GeneratedAndroidFirebaseFirestore.PigeonDocumentSnapshot.Builder pigeonDocumentSnapshot = new GeneratedAndroidFirebaseFirestore.PigeonDocumentSnapshot.Builder();
        pigeonDocumentSnapshot.setMetadata(PigeonParser.toPigeonSnapshotMetadata(documentSnapshot.getMetadata()));
        pigeonDocumentSnapshot.setData(documentSnapshot.getData(serverTimestampBehavior));
        pigeonDocumentSnapshot.setPath(documentSnapshot.getReference().getPath());
        return pigeonDocumentSnapshot.build();
    }

    public static List<GeneratedAndroidFirebaseFirestore.PigeonDocumentSnapshot> toPigeonDocumentSnapshots(List<DocumentSnapshot> documentSnapshots, DocumentSnapshot.ServerTimestampBehavior serverTimestampBehavior) {
        ArrayList<GeneratedAndroidFirebaseFirestore.PigeonDocumentSnapshot> pigeonDocumentSnapshots = new ArrayList<GeneratedAndroidFirebaseFirestore.PigeonDocumentSnapshot>(documentSnapshots.size());
        for (DocumentSnapshot documentSnapshot : documentSnapshots) {
            pigeonDocumentSnapshots.add(PigeonParser.toPigeonDocumentSnapshot(documentSnapshot, serverTimestampBehavior));
        }
        return pigeonDocumentSnapshots;
    }

    public static List<FieldPath> parseFieldPath(List<List<String>> fieldPaths) {
        ArrayList<FieldPath> paths = new ArrayList<FieldPath>(fieldPaths.size());
        for (List<String> fieldPath : fieldPaths) {
            paths.add(FieldPath.of((String[])fieldPath.toArray(new String[0])));
        }
        return paths;
    }

    public static Query parseQuery(FirebaseFirestore firestore, @NonNull String path, boolean isCollectionGroup, GeneratedAndroidFirebaseFirestore.PigeonQueryParameters parameters) {
        try {
            List<Object> endBefore;
            List<Object> endAt;
            List<Object> list;
            List<List<Object>> orderBy;
            Long limitToLast;
            boolean isFilterQuery;
            Object query = isCollectionGroup ? firestore.collectionGroup(path) : firestore.collection(path);
            if (parameters == null) {
                return query;
            }
            boolean bl = isFilterQuery = parameters.getFilters() != null;
            if (isFilterQuery) {
                Filter filter = PigeonParser.filterFromJson(parameters.getFilters());
                query = query.where(filter);
            }
            List<List<Object>> whereConditions = Objects.requireNonNull(parameters.getWhere());
            for (List<Object> condition : whereConditions) {
                List listValues;
                FieldPath fieldPath = (FieldPath)condition.get(0);
                String operator = (String)condition.get(1);
                Object object = condition.get(2);
                if ("==".equals(operator)) {
                    query = query.whereEqualTo(fieldPath, object);
                    continue;
                }
                if ("!=".equals(operator)) {
                    query = query.whereNotEqualTo(fieldPath, object);
                    continue;
                }
                if ("<".equals(operator)) {
                    query = query.whereLessThan(fieldPath, object);
                    continue;
                }
                if ("<=".equals(operator)) {
                    query = query.whereLessThanOrEqualTo(fieldPath, object);
                    continue;
                }
                if (">".equals(operator)) {
                    query = query.whereGreaterThan(fieldPath, object);
                    continue;
                }
                if (">=".equals(operator)) {
                    query = query.whereGreaterThanOrEqualTo(fieldPath, object);
                    continue;
                }
                if ("array-contains".equals(operator)) {
                    query = query.whereArrayContains(fieldPath, object);
                    continue;
                }
                if ("array-contains-any".equals(operator)) {
                    listValues = (List)object;
                    query = query.whereArrayContainsAny(fieldPath, listValues);
                    continue;
                }
                if ("in".equals(operator)) {
                    listValues = (List)object;
                    query = query.whereIn(fieldPath, listValues);
                    continue;
                }
                if ("not-in".equals(operator)) {
                    listValues = (List)object;
                    query = query.whereNotIn(fieldPath, listValues);
                    continue;
                }
                Log.w((String)"FLTFirestoreMsgCodec", (String)("An invalid query operator " + (String)operator + " was received but not handled."));
            }
            Long limit = parameters.getLimit();
            if (limit != null) {
                query = query.limit(((Number)limit).longValue());
            }
            if ((limitToLast = parameters.getLimitToLast()) != null) {
                query = query.limitToLast(((Number)limitToLast).longValue());
            }
            if ((orderBy = parameters.getOrderBy()) == null) {
                return query;
            }
            for (List list2 : orderBy) {
                FieldPath fieldPath = (FieldPath)list2.get(0);
                boolean descending = (Boolean)list2.get(1);
                Query.Direction direction = descending ? Query.Direction.DESCENDING : Query.Direction.ASCENDING;
                query = query.orderBy(fieldPath, direction);
            }
            List<Object> startAt = parameters.getStartAt();
            if (startAt != null) {
                query = query.startAt(Objects.requireNonNull(startAt.toArray()));
            }
            if ((list = parameters.getStartAfter()) != null) {
                query = query.startAfter(Objects.requireNonNull(list.toArray()));
            }
            if ((endAt = parameters.getEndAt()) != null) {
                query = query.endAt(Objects.requireNonNull(endAt.toArray()));
            }
            if ((endBefore = parameters.getEndBefore()) != null) {
                query = query.endBefore(Objects.requireNonNull(endBefore.toArray()));
            }
            return query;
        }
        catch (Exception exception) {
            Log.e((String)"FLTFirestoreMsgCodec", (String)"An error occurred while parsing query arguments, this is most likely an error with this SDK.", (Throwable)exception);
            return null;
        }
    }

    private static Filter filterFromJson(Map<String, Object> map) {
        if (map.containsKey("fieldPath")) {
            String op = (String)map.get("op");
            FieldPath fieldPath = (FieldPath)map.get("fieldPath");
            Object value = map.get("value");
            assert (fieldPath != null);
            assert (op != null);
            switch (op) {
                case "==": {
                    return Filter.equalTo((FieldPath)fieldPath, (Object)value);
                }
                case "!=": {
                    return Filter.notEqualTo((FieldPath)fieldPath, (Object)value);
                }
                case "<": {
                    return Filter.lessThan((FieldPath)fieldPath, (Object)value);
                }
                case "<=": {
                    return Filter.lessThanOrEqualTo((FieldPath)fieldPath, (Object)value);
                }
                case ">": {
                    return Filter.greaterThan((FieldPath)fieldPath, (Object)value);
                }
                case ">=": {
                    return Filter.greaterThanOrEqualTo((FieldPath)fieldPath, (Object)value);
                }
                case "array-contains": {
                    return Filter.arrayContains((FieldPath)fieldPath, (Object)value);
                }
                case "array-contains-any": {
                    return Filter.arrayContainsAny((FieldPath)fieldPath, (List)((List)value));
                }
                case "in": {
                    return Filter.inArray((FieldPath)fieldPath, (List)((List)value));
                }
                case "not-in": {
                    return Filter.notInArray((FieldPath)fieldPath, (List)((List)value));
                }
            }
            throw new Error("Invalid operator");
        }
        String op = (String)map.get("op");
        List queries = (List)map.get("queries");
        ArrayList<Filter> parsedFilters = new ArrayList<Filter>();
        for (Map query : queries) {
            parsedFilters.add(PigeonParser.filterFromJson(query));
        }
        if (op.equals("OR")) {
            return Filter.or((Filter[])parsedFilters.toArray(new Filter[0]));
        }
        if (op.equals("AND")) {
            return Filter.and((Filter[])parsedFilters.toArray(new Filter[0]));
        }
        throw new Error("Invalid operator");
    }

    public static AggregateSource parseAggregateSource(GeneratedAndroidFirebaseFirestore.AggregateSource source) {
        switch (source) {
            case SERVER: {
                return AggregateSource.SERVER;
            }
        }
        throw new IllegalArgumentException("Unknown AggregateSource value: " + (Object)((Object)source));
    }
}

