/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.auth;

import android.net.Uri;
import androidx.annotation.NonNull;
import com.google.firebase.auth.ActionCodeEmailInfo;
import com.google.firebase.auth.ActionCodeInfo;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.AdditionalUserInfo;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthProvider;
import com.google.firebase.auth.FacebookAuthProvider;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.FirebaseUserMetadata;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.GithubAuthProvider;
import com.google.firebase.auth.GoogleAuthProvider;
import com.google.firebase.auth.MultiFactorInfo;
import com.google.firebase.auth.OAuthCredential;
import com.google.firebase.auth.OAuthProvider;
import com.google.firebase.auth.PhoneAuthProvider;
import com.google.firebase.auth.PhoneMultiFactorInfo;
import com.google.firebase.auth.PlayGamesAuthProvider;
import com.google.firebase.auth.TwitterAuthProvider;
import com.google.firebase.auth.UserInfo;
import io.flutter.plugins.firebase.auth.FlutterFirebaseAuthPlugin;
import io.flutter.plugins.firebase.auth.FlutterFirebaseAuthPluginException;
import io.flutter.plugins.firebase.auth.GeneratedAndroidFirebaseAuth;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PigeonParser {
    static List<Object> manuallyToList(GeneratedAndroidFirebaseAuth.PigeonUserDetails pigeonUserDetails) {
        ArrayList<Object> output = new ArrayList<Object>();
        output.add(pigeonUserDetails.getUserInfo().toList());
        output.add(pigeonUserDetails.getProviderData());
        return output;
    }

    static GeneratedAndroidFirebaseAuth.PigeonUserCredential parseAuthResult(@NonNull AuthResult authResult) {
        GeneratedAndroidFirebaseAuth.PigeonUserCredential.Builder builder = new GeneratedAndroidFirebaseAuth.PigeonUserCredential.Builder();
        builder.setAdditionalUserInfo(PigeonParser.parseAdditionalUserInfo(authResult.getAdditionalUserInfo()));
        builder.setCredential(PigeonParser.parseAuthCredential(authResult.getCredential()));
        builder.setUser(PigeonParser.parseFirebaseUser(authResult.getUser()));
        return builder.build();
    }

    private static GeneratedAndroidFirebaseAuth.PigeonAdditionalUserInfo parseAdditionalUserInfo(AdditionalUserInfo additionalUserInfo) {
        if (additionalUserInfo == null) {
            return null;
        }
        GeneratedAndroidFirebaseAuth.PigeonAdditionalUserInfo.Builder builder = new GeneratedAndroidFirebaseAuth.PigeonAdditionalUserInfo.Builder();
        builder.setIsNewUser(additionalUserInfo.isNewUser());
        builder.setProfile(additionalUserInfo.getProfile());
        builder.setProviderId(additionalUserInfo.getProviderId());
        builder.setUsername(additionalUserInfo.getUsername());
        return builder.build();
    }

    static GeneratedAndroidFirebaseAuth.PigeonAuthCredential parseAuthCredential(AuthCredential authCredential) {
        if (authCredential == null) {
            return null;
        }
        int authCredentialHashCode = authCredential.hashCode();
        FlutterFirebaseAuthPlugin.authCredentials.put(authCredentialHashCode, authCredential);
        GeneratedAndroidFirebaseAuth.PigeonAuthCredential.Builder builder = new GeneratedAndroidFirebaseAuth.PigeonAuthCredential.Builder();
        builder.setProviderId(authCredential.getProvider());
        builder.setSignInMethod(authCredential.getSignInMethod());
        builder.setNativeId(Long.valueOf(authCredentialHashCode));
        if (authCredential instanceof OAuthCredential) {
            builder.setAccessToken(((OAuthCredential)authCredential).getAccessToken());
        }
        return builder.build();
    }

    static GeneratedAndroidFirebaseAuth.PigeonUserDetails parseFirebaseUser(FirebaseUser firebaseUser) {
        if (firebaseUser == null) {
            return null;
        }
        GeneratedAndroidFirebaseAuth.PigeonUserDetails.Builder builder = new GeneratedAndroidFirebaseAuth.PigeonUserDetails.Builder();
        GeneratedAndroidFirebaseAuth.PigeonUserInfo.Builder builderInfo = new GeneratedAndroidFirebaseAuth.PigeonUserInfo.Builder();
        builderInfo.setDisplayName(firebaseUser.getDisplayName());
        builderInfo.setEmail(firebaseUser.getEmail());
        builderInfo.setIsEmailVerified(firebaseUser.isEmailVerified());
        builderInfo.setIsAnonymous(firebaseUser.isAnonymous());
        FirebaseUserMetadata userMetadata = firebaseUser.getMetadata();
        if (userMetadata != null) {
            builderInfo.setCreationTimestamp(firebaseUser.getMetadata().getCreationTimestamp());
            builderInfo.setLastSignInTimestamp(firebaseUser.getMetadata().getLastSignInTimestamp());
        }
        builderInfo.setPhoneNumber(firebaseUser.getPhoneNumber());
        builderInfo.setPhotoUrl(PigeonParser.parsePhotoUrl(firebaseUser.getPhotoUrl()));
        builderInfo.setUid(firebaseUser.getUid());
        builderInfo.setTenantId(firebaseUser.getTenantId());
        builder.setUserInfo(builderInfo.build());
        builder.setProviderData(PigeonParser.parseUserInfoList(firebaseUser.getProviderData()));
        return builder.build();
    }

    private static List<Map<Object, Object>> parseUserInfoList(List<? extends UserInfo> userInfoList) {
        ArrayList<Map<Object, Object>> output = new ArrayList<Map<Object, Object>>();
        if (userInfoList == null) {
            return null;
        }
        for (UserInfo userInfo : new ArrayList<UserInfo>(userInfoList)) {
            if (userInfo == null || "firebase".equals(userInfo.getProviderId())) continue;
            output.add(PigeonParser.parseUserInfoToMap(userInfo));
        }
        return output;
    }

    private static Map<Object, Object> parseUserInfoToMap(UserInfo userInfo) {
        HashMap<Object, Object> output = new HashMap<Object, Object>();
        output.put("displayName", userInfo.getDisplayName());
        output.put("email", userInfo.getEmail());
        output.put("isEmailVerified", userInfo.isEmailVerified());
        output.put("phoneNumber", userInfo.getPhoneNumber());
        output.put("photoUrl", PigeonParser.parsePhotoUrl(userInfo.getPhotoUrl()));
        output.put("uid", userInfo.getUid() == null ? "" : userInfo.getUid());
        output.put("providerId", userInfo.getProviderId());
        output.put("isAnonymous", false);
        return output;
    }

    private static String parsePhotoUrl(Uri photoUri) {
        if (photoUri == null) {
            return null;
        }
        String photoUrl = photoUri.toString();
        return "".equals(photoUrl) ? null : photoUrl;
    }

    static AuthCredential getCredential(Map<String, Object> credentialMap) {
        if (credentialMap.get("token") != null) {
            int token = (Integer)credentialMap.get("token");
            AuthCredential credential = FlutterFirebaseAuthPlugin.authCredentials.get(token);
            if (credential == null) {
                throw FlutterFirebaseAuthPluginException.invalidCredential();
            }
            return credential;
        }
        String signInMethod = (String)Objects.requireNonNull(credentialMap.get("signInMethod"));
        String secret = (String)credentialMap.get("secret");
        String idToken = (String)credentialMap.get("idToken");
        String accessToken = (String)credentialMap.get("accessToken");
        String rawNonce = (String)credentialMap.get("rawNonce");
        switch (signInMethod) {
            case "password": {
                return EmailAuthProvider.getCredential((String)((String)Objects.requireNonNull(credentialMap.get("email"))), (String)Objects.requireNonNull(secret));
            }
            case "emailLink": {
                return EmailAuthProvider.getCredentialWithLink((String)((String)Objects.requireNonNull(credentialMap.get("email"))), (String)((String)Objects.requireNonNull(credentialMap.get("emailLink"))));
            }
            case "facebook.com": {
                return FacebookAuthProvider.getCredential((String)Objects.requireNonNull(accessToken));
            }
            case "google.com": {
                return GoogleAuthProvider.getCredential((String)idToken, (String)accessToken);
            }
            case "twitter.com": {
                return TwitterAuthProvider.getCredential((String)Objects.requireNonNull(accessToken), (String)Objects.requireNonNull(secret));
            }
            case "github.com": {
                return GithubAuthProvider.getCredential((String)Objects.requireNonNull(accessToken));
            }
            case "phone": {
                String verificationId = (String)Objects.requireNonNull(credentialMap.get("verificationId"));
                String smsCode = (String)Objects.requireNonNull(credentialMap.get("smsCode"));
                return PhoneAuthProvider.getCredential((String)verificationId, (String)smsCode);
            }
            case "oauth": {
                String providerId = (String)Objects.requireNonNull(credentialMap.get("providerId"));
                OAuthProvider.CredentialBuilder builder = OAuthProvider.newCredentialBuilder((String)providerId);
                if (accessToken != null) {
                    builder.setAccessToken(accessToken);
                }
                if (rawNonce == null) {
                    builder.setIdToken(Objects.requireNonNull(idToken));
                } else {
                    builder.setIdTokenWithRawNonce(Objects.requireNonNull(idToken), rawNonce);
                }
                return builder.build();
            }
            case "playgames.google.com": {
                String serverAuthCode = (String)Objects.requireNonNull(credentialMap.get("serverAuthCode"));
                return PlayGamesAuthProvider.getCredential((String)serverAuthCode);
            }
        }
        return null;
    }

    static ActionCodeSettings getActionCodeSettings(@NonNull GeneratedAndroidFirebaseAuth.PigeonActionCodeSettings pigeonActionCodeSettings) {
        ActionCodeSettings.Builder builder = ActionCodeSettings.newBuilder();
        builder.setUrl(pigeonActionCodeSettings.getUrl());
        if (pigeonActionCodeSettings.getDynamicLinkDomain() != null) {
            builder.setDynamicLinkDomain(pigeonActionCodeSettings.getDynamicLinkDomain());
        }
        if (pigeonActionCodeSettings.getLinkDomain() != null) {
            builder.setLinkDomain(pigeonActionCodeSettings.getLinkDomain());
        }
        builder.setHandleCodeInApp(pigeonActionCodeSettings.getHandleCodeInApp().booleanValue());
        if (pigeonActionCodeSettings.getAndroidPackageName() != null) {
            builder.setAndroidPackageName(pigeonActionCodeSettings.getAndroidPackageName(), pigeonActionCodeSettings.getAndroidInstallApp().booleanValue(), pigeonActionCodeSettings.getAndroidMinimumVersion());
        }
        if (pigeonActionCodeSettings.getIOSBundleId() != null) {
            builder.setIOSBundleId(pigeonActionCodeSettings.getIOSBundleId());
        }
        return builder.build();
    }

    static List<GeneratedAndroidFirebaseAuth.PigeonMultiFactorInfo> multiFactorInfoToPigeon(List<MultiFactorInfo> hints) {
        ArrayList<GeneratedAndroidFirebaseAuth.PigeonMultiFactorInfo> pigeonHints = new ArrayList<GeneratedAndroidFirebaseAuth.PigeonMultiFactorInfo>();
        for (MultiFactorInfo info : hints) {
            if (info instanceof PhoneMultiFactorInfo) {
                pigeonHints.add(new GeneratedAndroidFirebaseAuth.PigeonMultiFactorInfo.Builder().setPhoneNumber(((PhoneMultiFactorInfo)info).getPhoneNumber()).setDisplayName(info.getDisplayName()).setEnrollmentTimestamp(Double.valueOf(info.getEnrollmentTimestamp())).setUid(info.getUid()).setFactorId(info.getFactorId()).build());
                continue;
            }
            pigeonHints.add(new GeneratedAndroidFirebaseAuth.PigeonMultiFactorInfo.Builder().setDisplayName(info.getDisplayName()).setEnrollmentTimestamp(Double.valueOf(info.getEnrollmentTimestamp())).setUid(info.getUid()).setFactorId(info.getFactorId()).build());
        }
        return pigeonHints;
    }

    static List<List<Object>> multiFactorInfoToMap(List<MultiFactorInfo> hints) {
        ArrayList<List<Object>> pigeonHints = new ArrayList<List<Object>>();
        for (GeneratedAndroidFirebaseAuth.PigeonMultiFactorInfo info : PigeonParser.multiFactorInfoToPigeon(hints)) {
            pigeonHints.add(info.toList());
        }
        return pigeonHints;
    }

    static GeneratedAndroidFirebaseAuth.PigeonActionCodeInfo parseActionCodeResult(@NonNull ActionCodeResult actionCodeResult) {
        GeneratedAndroidFirebaseAuth.PigeonActionCodeInfo.Builder builder = new GeneratedAndroidFirebaseAuth.PigeonActionCodeInfo.Builder();
        GeneratedAndroidFirebaseAuth.PigeonActionCodeInfoData.Builder builderData = new GeneratedAndroidFirebaseAuth.PigeonActionCodeInfoData.Builder();
        int operation = actionCodeResult.getOperation();
        switch (operation) {
            case 0: {
                builder.setOperation(GeneratedAndroidFirebaseAuth.ActionCodeInfoOperation.PASSWORD_RESET);
                break;
            }
            case 1: {
                builder.setOperation(GeneratedAndroidFirebaseAuth.ActionCodeInfoOperation.VERIFY_EMAIL);
                break;
            }
            case 2: {
                builder.setOperation(GeneratedAndroidFirebaseAuth.ActionCodeInfoOperation.RECOVER_EMAIL);
                break;
            }
            case 4: {
                builder.setOperation(GeneratedAndroidFirebaseAuth.ActionCodeInfoOperation.EMAIL_SIGN_IN);
                break;
            }
            case 5: {
                builder.setOperation(GeneratedAndroidFirebaseAuth.ActionCodeInfoOperation.VERIFY_AND_CHANGE_EMAIL);
                break;
            }
            case 6: {
                builder.setOperation(GeneratedAndroidFirebaseAuth.ActionCodeInfoOperation.REVERT_SECOND_FACTOR_ADDITION);
            }
        }
        ActionCodeInfo actionCodeInfo = actionCodeResult.getInfo();
        if (actionCodeInfo != null && operation == 1 || operation == 0) {
            builderData.setEmail(actionCodeInfo.getEmail());
        } else if (operation == 2 || operation == 5) {
            ActionCodeEmailInfo actionCodeEmailInfo = (ActionCodeEmailInfo)Objects.requireNonNull(actionCodeInfo);
            builderData.setEmail(actionCodeEmailInfo.getEmail());
            builderData.setPreviousEmail(actionCodeEmailInfo.getPreviousEmail());
        }
        builder.setData(builderData.build());
        return builder.build();
    }

    static GeneratedAndroidFirebaseAuth.PigeonIdTokenResult parseTokenResult(@NonNull GetTokenResult tokenResult) {
        GeneratedAndroidFirebaseAuth.PigeonIdTokenResult.Builder builder = new GeneratedAndroidFirebaseAuth.PigeonIdTokenResult.Builder();
        builder.setToken(tokenResult.getToken());
        builder.setSignInProvider(tokenResult.getSignInProvider());
        builder.setAuthTimestamp(tokenResult.getAuthTimestamp() * 1000L);
        builder.setExpirationTimestamp(tokenResult.getExpirationTimestamp() * 1000L);
        builder.setIssuedAtTimestamp(tokenResult.getIssuedAtTimestamp() * 1000L);
        builder.setClaims(tokenResult.getClaims());
        builder.setSignInSecondFactor(tokenResult.getSignInSecondFactor());
        return builder.build();
    }
}

