/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.firestore.streamhandler;

import com.google.firebase.firestore.DocumentChange;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.ListenSource;
import com.google.firebase.firestore.ListenerRegistration;
import com.google.firebase.firestore.MetadataChanges;
import com.google.firebase.firestore.Query;
import com.google.firebase.firestore.SnapshotListenOptions;
import io.flutter.plugin.common.EventChannel;
import io.flutter.plugins.firebase.firestore.utils.ExceptionConverter;
import io.flutter.plugins.firebase.firestore.utils.PigeonParser;
import java.util.ArrayList;
import java.util.Map;

public class QuerySnapshotsStreamHandler
implements EventChannel.StreamHandler {
    ListenerRegistration listenerRegistration;
    Query query;
    MetadataChanges metadataChanges;
    DocumentSnapshot.ServerTimestampBehavior serverTimestampBehavior;
    ListenSource source;

    public QuerySnapshotsStreamHandler(Query query, Boolean includeMetadataChanges, DocumentSnapshot.ServerTimestampBehavior serverTimestampBehavior, ListenSource source) {
        this.query = query;
        this.metadataChanges = includeMetadataChanges != false ? MetadataChanges.INCLUDE : MetadataChanges.EXCLUDE;
        this.serverTimestampBehavior = serverTimestampBehavior;
        this.source = source;
    }

    public void onListen(Object arguments, EventChannel.EventSink events) {
        SnapshotListenOptions.Builder optionsBuilder = new SnapshotListenOptions.Builder();
        optionsBuilder.setMetadataChanges(this.metadataChanges);
        optionsBuilder.setSource(this.source);
        this.listenerRegistration = this.query.addSnapshotListener(optionsBuilder.build(), (querySnapshot, exception) -> {
            if (exception != null) {
                Map<String, String> exceptionDetails = ExceptionConverter.createDetails((Exception)exception);
                events.error("firebase_firestore", exception.getMessage(), exceptionDetails);
                events.endOfStream();
                this.onCancel(null);
            } else {
                ArrayList toListResult = new ArrayList(3);
                ArrayList<ArrayList<Object>> documents = new ArrayList<ArrayList<Object>>(querySnapshot.getDocuments().size());
                ArrayList<ArrayList<Object>> documentChanges = new ArrayList<ArrayList<Object>>(querySnapshot.getDocumentChanges().size());
                for (DocumentSnapshot documentSnapshot : querySnapshot.getDocuments()) {
                    documents.add(PigeonParser.toPigeonDocumentSnapshot(documentSnapshot, this.serverTimestampBehavior).toList());
                }
                for (DocumentChange documentChange : querySnapshot.getDocumentChanges()) {
                    documentChanges.add(PigeonParser.toPigeonDocumentChange(documentChange, this.serverTimestampBehavior).toList());
                }
                toListResult.add(documents);
                toListResult.add(documentChanges);
                toListResult.add(PigeonParser.toPigeonSnapshotMetadata(querySnapshot.getMetadata()).toList());
                events.success(toListResult);
            }
        });
    }

    public void onCancel(Object arguments) {
        if (this.listenerRegistration != null) {
            this.listenerRegistration.remove();
            this.listenerRegistration = null;
        }
    }
}

