/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.urllauncher;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.embedding.engine.plugins.activity.ActivityAware;
import io.flutter.embedding.engine.plugins.activity.ActivityPluginBinding;
import io.flutter.plugins.urllauncher.Messages;
import io.flutter.plugins.urllauncher.UrlLauncher;

public final class UrlLauncherPlugin
implements FlutterPlugin,
ActivityAware {
    private static final String TAG = "UrlLauncherPlugin";
    @Nullable
    private UrlLauncher urlLauncher;

    public void onAttachedToEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        this.urlLauncher = new UrlLauncher(binding.getApplicationContext());
        Messages.UrlLauncherApi.setUp(binding.getBinaryMessenger(), this.urlLauncher);
    }

    public void onDetachedFromEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        if (this.urlLauncher == null) {
            Log.wtf((String)TAG, (String)"Already detached from the engine.");
            return;
        }
        Messages.UrlLauncherApi.setUp(binding.getBinaryMessenger(), null);
        this.urlLauncher = null;
    }

    public void onAttachedToActivity(@NonNull ActivityPluginBinding binding) {
        if (this.urlLauncher == null) {
            Log.wtf((String)TAG, (String)"urlLauncher was never set.");
            return;
        }
        this.urlLauncher.setActivity(binding.getActivity());
    }

    public void onDetachedFromActivity() {
        if (this.urlLauncher == null) {
            Log.wtf((String)TAG, (String)"urlLauncher was never set.");
            return;
        }
        this.urlLauncher.setActivity(null);
    }

    public void onDetachedFromActivityForConfigChanges() {
        this.onDetachedFromActivity();
    }

    public void onReattachedToActivityForConfigChanges(@NonNull ActivityPluginBinding binding) {
        this.onAttachedToActivity(binding);
    }
}

