/*
 * Decompiled with CFR 0.152.
 */
package com.baseflow.permissionhandler;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.PowerManager;
import android.provider.Settings;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import androidx.core.app.NotificationManagerCompat;
import androidx.core.content.ContextCompat;
import com.baseflow.permissionhandler.ErrorCallback;
import com.baseflow.permissionhandler.PermissionUtils;
import io.flutter.plugin.common.PluginRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

final class PermissionManager
implements PluginRegistry.ActivityResultListener,
PluginRegistry.RequestPermissionsResultListener {
    @NonNull
    private final Context context;
    @Nullable
    private RequestPermissionsSuccessCallback successCallback;
    @Nullable
    private Activity activity;
    private int pendingRequestCount;
    private Map<Integer, Integer> requestResults;

    public PermissionManager(@NonNull Context context) {
        this.context = context;
    }

    public void setActivity(@Nullable Activity activity) {
        this.activity = activity;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        int status;
        int permission2;
        if (this.activity == null) {
            return false;
        }
        if (this.requestResults == null) {
            this.pendingRequestCount = 0;
            return false;
        }
        if (requestCode == 209) {
            permission2 = 16;
            if (Build.VERSION.SDK_INT >= 23) {
                String packageName = this.context.getPackageName();
                PowerManager pm = (PowerManager)this.context.getSystemService("power");
                status = pm != null && pm.isIgnoringBatteryOptimizations(packageName) ? 1 : 0;
            } else {
                status = 2;
            }
        } else if (requestCode == 210) {
            if (Build.VERSION.SDK_INT < 30) {
                return false;
            }
            status = Environment.isExternalStorageManager() ? 1 : 0;
            permission2 = 22;
        } else if (requestCode == 211) {
            if (Build.VERSION.SDK_INT < 23) return false;
            status = Settings.canDrawOverlays((Context)this.activity) ? 1 : 0;
            permission2 = 23;
        } else if (requestCode == 212) {
            if (Build.VERSION.SDK_INT < 26) return false;
            status = this.activity.getPackageManager().canRequestPackageInstalls() ? 1 : 0;
            permission2 = 24;
        } else if (requestCode == 213) {
            if (Build.VERSION.SDK_INT < 23) return false;
            NotificationManager notificationManager = (NotificationManager)this.activity.getSystemService("notification");
            status = notificationManager.isNotificationPolicyAccessGranted() ? 1 : 0;
            permission2 = 27;
        } else {
            if (requestCode != 214) return false;
            permission2 = 34;
            AlarmManager alarmManager = (AlarmManager)this.activity.getSystemService("alarm");
            status = Build.VERSION.SDK_INT >= 31 ? (alarmManager.canScheduleExactAlarms() ? 1 : 0) : 1;
        }
        this.requestResults.put(permission2, status);
        --this.pendingRequestCount;
        if (this.successCallback == null || this.pendingRequestCount != 0) return true;
        this.successCallback.onSuccess(this.requestResults);
        return true;
    }

    public boolean onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode != 24) {
            this.pendingRequestCount = 0;
            return false;
        }
        if (this.requestResults == null) {
            return false;
        }
        if (permissions.length == 0 && grantResults.length == 0) {
            Log.w((String)"permissions_handler", (String)"onRequestPermissionsResult is called without results. This is probably caused by interfering request codes. If you see this error, please file an issue in flutter-permission-handler, including a list of plugins used by this application: https://github.com/Baseflow/flutter-permission-handler/issues");
            return false;
        }
        List<String> permissionList = Arrays.asList(permissions);
        int calendarWriteIndex = permissionList.indexOf("android.permission.WRITE_CALENDAR");
        if (calendarWriteIndex >= 0) {
            int writeGrantResult = grantResults[calendarWriteIndex];
            int writeStatus = PermissionUtils.toPermissionStatus(this.activity, "android.permission.WRITE_CALENDAR", writeGrantResult);
            this.requestResults.put(36, writeStatus);
            int calendarReadIndex = permissionList.indexOf("android.permission.READ_CALENDAR");
            if (calendarReadIndex >= 0) {
                int readGrantResult = grantResults[calendarReadIndex];
                int readStatus = PermissionUtils.toPermissionStatus(this.activity, "android.permission.READ_CALENDAR", readGrantResult);
                int fullAccessStatus = PermissionUtils.strictestStatus(writeStatus, readStatus);
                this.requestResults.put(37, fullAccessStatus);
                this.requestResults.put(0, fullAccessStatus);
            }
        }
        for (int i = 0; i < permissions.length; ++i) {
            int permissionStatus;
            int permission2;
            String permissionName = permissions[i];
            if (permissionName.equals("android.permission.WRITE_CALENDAR") || permissionName.equals("android.permission.READ_CALENDAR") || (permission2 = PermissionUtils.parseManifestName(permissionName)) == 20) continue;
            int result = grantResults[i];
            if (permission2 == 8) {
                Integer previousResult = this.requestResults.get(8);
                int newResult = PermissionUtils.toPermissionStatus(this.activity, permissionName, result);
                Integer strictestStatus = PermissionUtils.strictestStatus(previousResult, newResult);
                this.requestResults.put(8, strictestStatus);
                continue;
            }
            if (permission2 == 7) {
                if (!this.requestResults.containsKey(7)) {
                    this.requestResults.put(7, PermissionUtils.toPermissionStatus(this.activity, permissionName, result));
                }
                if (this.requestResults.containsKey(14)) continue;
                this.requestResults.put(14, PermissionUtils.toPermissionStatus(this.activity, permissionName, result));
                continue;
            }
            if (permission2 == 4) {
                permissionStatus = PermissionUtils.toPermissionStatus(this.activity, permissionName, result);
                if (this.requestResults.containsKey(4)) continue;
                this.requestResults.put(4, permissionStatus);
                continue;
            }
            if (permission2 == 3) {
                permissionStatus = PermissionUtils.toPermissionStatus(this.activity, permissionName, result);
                if (Build.VERSION.SDK_INT < 29 && !this.requestResults.containsKey(4)) {
                    this.requestResults.put(4, permissionStatus);
                }
                if (!this.requestResults.containsKey(5)) {
                    this.requestResults.put(5, permissionStatus);
                }
                this.requestResults.put(permission2, permissionStatus);
                continue;
            }
            if (permission2 == 9 || permission2 == 32) {
                this.requestResults.put(permission2, this.determinePermissionStatus(permission2));
                continue;
            }
            if (this.requestResults.containsKey(permission2)) continue;
            this.requestResults.put(permission2, PermissionUtils.toPermissionStatus(this.activity, permissionName, result));
        }
        this.pendingRequestCount -= grantResults.length;
        if (this.successCallback != null && this.pendingRequestCount == 0) {
            this.successCallback.onSuccess(this.requestResults);
        }
        return true;
    }

    void checkPermissionStatus(int permission2, CheckPermissionsSuccessCallback successCallback) {
        successCallback.onSuccess(this.determinePermissionStatus(permission2));
    }

    void requestPermissions(List<Integer> permissions, RequestPermissionsSuccessCallback successCallback, ErrorCallback errorCallback) {
        if (this.pendingRequestCount > 0) {
            errorCallback.onError("PermissionHandler.PermissionManager", "A request for permissions is already running, please wait for it to finish before doing another request (note that you can request multiple permissions at the same time).");
            return;
        }
        if (this.activity == null) {
            Log.d((String)"permissions_handler", (String)"Unable to detect current Activity.");
            errorCallback.onError("PermissionHandler.PermissionManager", "Unable to detect current Android Activity.");
            return;
        }
        this.successCallback = successCallback;
        this.requestResults = new HashMap<Integer, Integer>();
        this.pendingRequestCount = 0;
        ArrayList<String> permissionsToRequest = new ArrayList<String>();
        for (Integer permission2 : permissions) {
            int permissionStatus = this.determinePermissionStatus(permission2);
            if (permissionStatus == 1) {
                if (this.requestResults.containsKey(permission2)) continue;
                this.requestResults.put(permission2, 1);
                continue;
            }
            List<String> names = PermissionUtils.getManifestNames((Context)this.activity, permission2);
            if (names == null || names.isEmpty()) {
                if (this.requestResults.containsKey(permission2)) continue;
                if (permission2 == 16 && Build.VERSION.SDK_INT < 23) {
                    this.requestResults.put(permission2, 2);
                } else {
                    this.requestResults.put(permission2, 0);
                }
                if (permission2 == 22 && Build.VERSION.SDK_INT < 30) {
                    this.requestResults.put(permission2, 2);
                    continue;
                }
                this.requestResults.put(permission2, 0);
                continue;
            }
            if (Build.VERSION.SDK_INT >= 23 && permission2 == 16) {
                this.launchSpecialPermission("android.settings.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS", 209);
                continue;
            }
            if (Build.VERSION.SDK_INT >= 30 && permission2 == 22) {
                this.launchSpecialPermission("android.settings.MANAGE_APP_ALL_FILES_ACCESS_PERMISSION", 210);
                continue;
            }
            if (Build.VERSION.SDK_INT >= 23 && permission2 == 23) {
                this.launchSpecialPermission("android.settings.action.MANAGE_OVERLAY_PERMISSION", 211);
                continue;
            }
            if (Build.VERSION.SDK_INT >= 26 && permission2 == 24) {
                this.launchSpecialPermission("android.settings.MANAGE_UNKNOWN_APP_SOURCES", 212);
                continue;
            }
            if (Build.VERSION.SDK_INT >= 23 && permission2 == 27) {
                this.launchSpecialPermission("android.settings.NOTIFICATION_POLICY_ACCESS_SETTINGS", 213);
                continue;
            }
            if (Build.VERSION.SDK_INT >= 31 && permission2 == 34) {
                this.launchSpecialPermission("android.settings.REQUEST_SCHEDULE_EXACT_ALARM", 214);
                continue;
            }
            if (permission2 == 37 || permission2 == 0) {
                boolean isValidManifest = this.isValidManifestForCalendarFullAccess();
                if (isValidManifest) {
                    permissionsToRequest.add("android.permission.WRITE_CALENDAR");
                    permissionsToRequest.add("android.permission.READ_CALENDAR");
                    this.pendingRequestCount += 2;
                    continue;
                }
                this.requestResults.put(permission2, 0);
                continue;
            }
            permissionsToRequest.addAll(names);
            this.pendingRequestCount += names.size();
        }
        if (permissionsToRequest.size() > 0) {
            String[] requestPermissions = permissionsToRequest.toArray(new String[0]);
            ActivityCompat.requestPermissions((Activity)this.activity, (String[])requestPermissions, (int)24);
        }
        if (this.successCallback != null && this.pendingRequestCount == 0) {
            this.successCallback.onSuccess(this.requestResults);
        }
    }

    private int determinePermissionStatus(int permission2) {
        boolean requiresExplicitPermission;
        boolean isValidManifest;
        if (permission2 == 17) {
            return this.checkNotificationPermissionStatus();
        }
        if (permission2 == 21) {
            return this.checkBluetoothPermissionStatus();
        }
        if ((permission2 == 30 || permission2 == 28 || permission2 == 29) && Build.VERSION.SDK_INT < 31) {
            return this.checkBluetoothPermissionStatus();
        }
        if (!(permission2 != 37 && permission2 != 0 || (isValidManifest = this.isValidManifestForCalendarFullAccess()))) {
            return 0;
        }
        List<String> names = PermissionUtils.getManifestNames(this.context, permission2);
        if (names == null) {
            Log.d((String)"permissions_handler", (String)("No android specific permissions needed for: " + permission2));
            return 1;
        }
        if (names.size() == 0) {
            Log.d((String)"permissions_handler", (String)("No permissions found in manifest for: " + names + permission2));
            if (permission2 == 16 && Build.VERSION.SDK_INT < 23) {
                return 2;
            }
            if (permission2 == 22 && Build.VERSION.SDK_INT < 30) {
                return 2;
            }
            return Build.VERSION.SDK_INT < 23 ? 1 : 0;
        }
        boolean bl = requiresExplicitPermission = this.context.getApplicationInfo().targetSdkVersion >= 23;
        if (requiresExplicitPermission) {
            HashSet<Integer> permissionStatuses = new HashSet<Integer>();
            for (String name : names) {
                if (permission2 == 16) {
                    String packageName = this.context.getPackageName();
                    PowerManager pm = (PowerManager)this.context.getSystemService("power");
                    if (pm != null && pm.isIgnoringBatteryOptimizations(packageName)) {
                        permissionStatuses.add(1);
                        continue;
                    }
                    permissionStatuses.add(0);
                    continue;
                }
                if (permission2 == 22) {
                    if (Build.VERSION.SDK_INT < 30) {
                        permissionStatuses.add(2);
                    }
                    int status = Environment.isExternalStorageManager() ? 1 : 0;
                    permissionStatuses.add(status);
                    continue;
                }
                if (permission2 == 23) {
                    int status = Settings.canDrawOverlays((Context)this.context) ? 1 : 0;
                    permissionStatuses.add(status);
                    continue;
                }
                if (permission2 == 24) {
                    if (Build.VERSION.SDK_INT < 26) continue;
                    int status = this.context.getPackageManager().canRequestPackageInstalls() ? 1 : 0;
                    permissionStatuses.add(status);
                    continue;
                }
                if (permission2 == 27) {
                    NotificationManager notificationManager = (NotificationManager)this.context.getSystemService("notification");
                    int status = notificationManager.isNotificationPolicyAccessGranted() ? 1 : 0;
                    permissionStatuses.add(status);
                    continue;
                }
                if (permission2 == 34) {
                    if (Build.VERSION.SDK_INT >= 31) {
                        AlarmManager alarmManager = (AlarmManager)this.context.getSystemService("alarm");
                        int status = alarmManager.canScheduleExactAlarms() ? 1 : 0;
                        permissionStatuses.add(status);
                        continue;
                    }
                    permissionStatuses.add(1);
                    continue;
                }
                if (permission2 == 9 || permission2 == 32) {
                    int permissionStatus;
                    int permissionStatusLimited = permissionStatus = ContextCompat.checkSelfPermission((Context)this.context, (String)name);
                    if (Build.VERSION.SDK_INT >= 34) {
                        permissionStatusLimited = ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.READ_MEDIA_VISUAL_USER_SELECTED");
                    }
                    if (permissionStatusLimited == 0 && permissionStatus == -1) {
                        permissionStatuses.add(3);
                        continue;
                    }
                    if (permissionStatus == 0) {
                        permissionStatuses.add(1);
                        continue;
                    }
                    permissionStatuses.add(PermissionUtils.determineDeniedVariant(this.activity, name));
                    continue;
                }
                int permissionStatus = ContextCompat.checkSelfPermission((Context)this.context, (String)name);
                if (permissionStatus == 0) continue;
                permissionStatuses.add(PermissionUtils.determineDeniedVariant(this.activity, name));
            }
            if (!permissionStatuses.isEmpty()) {
                return PermissionUtils.strictestStatus(permissionStatuses);
            }
        }
        return 1;
    }

    private void launchSpecialPermission(String permissionAction, int requestCode) {
        if (this.activity == null) {
            return;
        }
        Intent intent = new Intent(permissionAction);
        if (!permissionAction.equals("android.settings.NOTIFICATION_POLICY_ACCESS_SETTINGS")) {
            String packageName = this.activity.getPackageName();
            intent.setData(Uri.parse((String)("package:" + packageName)));
        }
        this.activity.startActivityForResult(intent, requestCode);
        ++this.pendingRequestCount;
    }

    void shouldShowRequestPermissionRationale(int permission2, ShouldShowRequestPermissionRationaleSuccessCallback successCallback, ErrorCallback errorCallback) {
        if (this.activity == null) {
            Log.d((String)"permissions_handler", (String)"Unable to detect current Activity.");
            errorCallback.onError("PermissionHandler.PermissionManager", "Unable to detect current Android Activity.");
            return;
        }
        List<String> names = PermissionUtils.getManifestNames((Context)this.activity, permission2);
        if (names == null) {
            Log.d((String)"permissions_handler", (String)("No android specific permissions needed for: " + permission2));
            successCallback.onSuccess(false);
            return;
        }
        if (names.isEmpty()) {
            Log.d((String)"permissions_handler", (String)("No permissions found in manifest for: " + permission2 + " no need to show request rationale"));
            successCallback.onSuccess(false);
            return;
        }
        successCallback.onSuccess(ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.activity, (String)names.get(0)));
    }

    private int checkNotificationPermissionStatus() {
        if (Build.VERSION.SDK_INT < 33) {
            NotificationManagerCompat manager = NotificationManagerCompat.from((Context)this.context);
            boolean isGranted = manager.areNotificationsEnabled();
            if (isGranted) {
                return 1;
            }
            return 0;
        }
        int status = this.context.checkSelfPermission("android.permission.POST_NOTIFICATIONS");
        if (status == 0) {
            return 1;
        }
        return PermissionUtils.determineDeniedVariant(this.activity, "android.permission.POST_NOTIFICATIONS");
    }

    private int checkBluetoothPermissionStatus() {
        boolean missingInManifest;
        List<String> names = PermissionUtils.getManifestNames(this.context, 21);
        boolean bl = missingInManifest = names == null || names.isEmpty();
        if (missingInManifest) {
            Log.d((String)"permissions_handler", (String)"Bluetooth permission missing in manifest");
            return 0;
        }
        return 1;
    }

    private boolean isValidManifestForCalendarFullAccess() {
        boolean validManifest;
        List<String> names = PermissionUtils.getManifestNames(this.context, 37);
        boolean writeInManifest = names != null && names.contains("android.permission.WRITE_CALENDAR");
        boolean readInManifest = names != null && names.contains("android.permission.READ_CALENDAR");
        boolean bl = validManifest = writeInManifest && readInManifest;
        if (!validManifest) {
            if (!writeInManifest) {
                Log.d((String)"permissions_handler", (String)"android.permission.WRITE_CALENDAR missing in manifest");
            }
            if (!readInManifest) {
                Log.d((String)"permissions_handler", (String)"android.permission.READ_CALENDAR missing in manifest");
            }
            return false;
        }
        return true;
    }

    @FunctionalInterface
    static interface RequestPermissionsSuccessCallback {
        public void onSuccess(Map<Integer, Integer> var1);
    }

    @FunctionalInterface
    static interface CheckPermissionsSuccessCallback {
        public void onSuccess(int var1);
    }

    @FunctionalInterface
    static interface ShouldShowRequestPermissionRationaleSuccessCallback {
        public void onSuccess(boolean var1);
    }
}

