/*
 * Decompiled with CFR 0.152.
 */
package com.baseflow.permissionhandler;

import android.content.Context;
import androidx.annotation.NonNull;
import com.baseflow.permissionhandler.AppSettingsManager;
import com.baseflow.permissionhandler.PermissionManager;
import com.baseflow.permissionhandler.ServiceManager;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import java.util.List;

final class MethodCallHandlerImpl
implements MethodChannel.MethodCallHandler {
    private final Context applicationContext;
    private final AppSettingsManager appSettingsManager;
    private final PermissionManager permissionManager;
    private final ServiceManager serviceManager;

    MethodCallHandlerImpl(Context applicationContext, AppSettingsManager appSettingsManager, PermissionManager permissionManager, ServiceManager serviceManager) {
        this.applicationContext = applicationContext;
        this.appSettingsManager = appSettingsManager;
        this.permissionManager = permissionManager;
        this.serviceManager = serviceManager;
    }

    public void onMethodCall(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
        switch (call.method) {
            case "checkServiceStatus": {
                int permission2 = Integer.parseInt(call.arguments.toString());
                this.serviceManager.checkServiceStatus(permission2, this.applicationContext, arg_0 -> ((MethodChannel.Result)result).success(arg_0), (errorCode, errorDescription) -> result.error(errorCode, errorDescription, null));
                break;
            }
            case "checkPermissionStatus": {
                int permission3 = Integer.parseInt(call.arguments.toString());
                this.permissionManager.checkPermissionStatus(permission3, arg_0 -> ((MethodChannel.Result)result).success(arg_0));
                break;
            }
            case "requestPermissions": {
                List permissions = (List)call.arguments();
                this.permissionManager.requestPermissions(permissions, arg_0 -> ((MethodChannel.Result)result).success(arg_0), (errorCode, errorDescription) -> result.error(errorCode, errorDescription, null));
                break;
            }
            case "shouldShowRequestPermissionRationale": {
                int permission4 = Integer.parseInt(call.arguments.toString());
                this.permissionManager.shouldShowRequestPermissionRationale(permission4, arg_0 -> ((MethodChannel.Result)result).success(arg_0), (errorCode, errorDescription) -> result.error(errorCode, errorDescription, null));
                break;
            }
            case "openAppSettings": {
                this.appSettingsManager.openAppSettings(this.applicationContext, arg_0 -> ((MethodChannel.Result)result).success(arg_0), (errorCode, errorDescription) -> result.error(errorCode, errorDescription, null));
                break;
            }
            default: {
                result.notImplemented();
            }
        }
    }
}

