/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.core;

import androidx.annotation.Keep;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import io.flutter.plugins.firebase.core.FlutterFirebasePlugin;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

@Keep
public class FlutterFirebasePluginRegistry {
    private static final Map<String, FlutterFirebasePlugin> registeredPlugins = new WeakHashMap<String, FlutterFirebasePlugin>();

    public static void registerPlugin(String channelName, FlutterFirebasePlugin flutterFirebasePlugin) {
        registeredPlugins.put(channelName, flutterFirebasePlugin);
    }

    static Task<Map<String, Object>> getPluginConstantsForFirebaseApp(FirebaseApp firebaseApp) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        FlutterFirebasePlugin.cachedThreadPool.execute(() -> {
            try {
                HashMap<String, Object> pluginConstants = new HashMap<String, Object>(registeredPlugins.size());
                for (Map.Entry<String, FlutterFirebasePlugin> entry : registeredPlugins.entrySet()) {
                    String channelName = entry.getKey();
                    FlutterFirebasePlugin plugin = entry.getValue();
                    pluginConstants.put(channelName, Tasks.await(plugin.getPluginConstantsForFirebaseApp(firebaseApp)));
                }
                taskCompletionSource.setResult(pluginConstants);
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        return taskCompletionSource.getTask();
    }

    static Task<Void> didReinitializeFirebaseCore() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        FlutterFirebasePlugin.cachedThreadPool.execute(() -> {
            try {
                for (Map.Entry<String, FlutterFirebasePlugin> entry : registeredPlugins.entrySet()) {
                    FlutterFirebasePlugin plugin = entry.getValue();
                    Tasks.await(plugin.didReinitializeFirebaseCore());
                }
                taskCompletionSource.setResult(null);
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        return taskCompletionSource.getTask();
    }
}

