/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.core;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MessageCodec;
import io.flutter.plugin.common.StandardMessageCodec;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GeneratedAndroidFirebaseCore {
    @NonNull
    protected static ArrayList<Object> wrapError(@NonNull Throwable exception) {
        ArrayList<Object> errorList = new ArrayList<Object>(3);
        if (exception instanceof FlutterError) {
            FlutterError error = (FlutterError)exception;
            errorList.add(error.code);
            errorList.add(error.getMessage());
            errorList.add(error.details);
        } else {
            errorList.add(exception.toString());
            errorList.add(exception.getClass().getSimpleName());
            errorList.add("Cause: " + exception.getCause() + ", Stacktrace: " + Log.getStackTraceString((Throwable)exception));
        }
        return errorList;
    }

    public static class FlutterError
    extends RuntimeException {
        public final String code;
        public final Object details;

        public FlutterError(@NonNull String code, @Nullable String message, @Nullable Object details) {
            super(message);
            this.code = code;
            this.details = details;
        }
    }

    public static interface FirebaseAppHostApi {
        public void setAutomaticDataCollectionEnabled(@NonNull String var1, @NonNull Boolean var2, @NonNull Result<Void> var3);

        public void setAutomaticResourceManagementEnabled(@NonNull String var1, @NonNull Boolean var2, @NonNull Result<Void> var3);

        public void delete(@NonNull String var1, @NonNull Result<Void> var2);

        @NonNull
        public static MessageCodec<Object> getCodec() {
            return new StandardMessageCodec();
        }

        public static void setup(@NonNull BinaryMessenger binaryMessenger, @Nullable FirebaseAppHostApi api) {
            BasicMessageChannel channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.FirebaseAppHostApi.setAutomaticDataCollectionEnabled", FirebaseAppHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    String appNameArg = (String)args.get(0);
                    Boolean enabledArg = (Boolean)args.get(1);
                    Result<Void> resultCallback = new Result<Void>(){

                        @Override
                        public void success(Void result) {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseCore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.setAutomaticDataCollectionEnabled(appNameArg, enabledArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.FirebaseAppHostApi.setAutomaticResourceManagementEnabled", FirebaseAppHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    String appNameArg = (String)args.get(0);
                    Boolean enabledArg = (Boolean)args.get(1);
                    Result<Void> resultCallback = new Result<Void>(){

                        @Override
                        public void success(Void result) {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseCore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.setAutomaticResourceManagementEnabled(appNameArg, enabledArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.FirebaseAppHostApi.delete", FirebaseAppHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    String appNameArg = (String)args.get(0);
                    Result<Void> resultCallback = new Result<Void>(){

                        @Override
                        public void success(Void result) {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseCore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.delete(appNameArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
        }
    }

    public static interface FirebaseCoreHostApi {
        public void initializeApp(@NonNull String var1, @NonNull PigeonFirebaseOptions var2, @NonNull Result<PigeonInitializeResponse> var3);

        public void initializeCore(@NonNull Result<List<PigeonInitializeResponse>> var1);

        public void optionsFromResource(@NonNull Result<PigeonFirebaseOptions> var1);

        @NonNull
        public static MessageCodec<Object> getCodec() {
            return FirebaseCoreHostApiCodec.INSTANCE;
        }

        public static void setup(@NonNull BinaryMessenger binaryMessenger, @Nullable FirebaseCoreHostApi api) {
            BasicMessageChannel channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.FirebaseCoreHostApi.initializeApp", FirebaseCoreHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    String appNameArg = (String)args.get(0);
                    PigeonFirebaseOptions initializeAppRequestArg = (PigeonFirebaseOptions)args.get(1);
                    Result<PigeonInitializeResponse> resultCallback = new Result<PigeonInitializeResponse>(){

                        @Override
                        public void success(PigeonInitializeResponse result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseCore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.initializeApp(appNameArg, initializeAppRequestArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.FirebaseCoreHostApi.initializeCore", FirebaseCoreHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    Result<List<PigeonInitializeResponse>> resultCallback = new Result<List<PigeonInitializeResponse>>(){

                        @Override
                        public void success(List<PigeonInitializeResponse> result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseCore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.initializeCore(resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.FirebaseCoreHostApi.optionsFromResource", FirebaseCoreHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    Result<PigeonFirebaseOptions> resultCallback = new Result<PigeonFirebaseOptions>(){

                        @Override
                        public void success(PigeonFirebaseOptions result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseCore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.optionsFromResource(resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
        }
    }

    private static class FirebaseCoreHostApiCodec
    extends StandardMessageCodec {
        public static final FirebaseCoreHostApiCodec INSTANCE = new FirebaseCoreHostApiCodec();

        private FirebaseCoreHostApiCodec() {
        }

        protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
            switch (type) {
                case -128: {
                    return PigeonFirebaseOptions.fromList((ArrayList)this.readValue(buffer));
                }
                case -127: {
                    return PigeonInitializeResponse.fromList((ArrayList)this.readValue(buffer));
                }
            }
            return super.readValueOfType(type, buffer);
        }

        protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
            if (value instanceof PigeonFirebaseOptions) {
                stream.write(128);
                this.writeValue(stream, ((PigeonFirebaseOptions)value).toList());
            } else if (value instanceof PigeonInitializeResponse) {
                stream.write(129);
                this.writeValue(stream, ((PigeonInitializeResponse)value).toList());
            } else {
                super.writeValue(stream, value);
            }
        }
    }

    public static interface Result<T> {
        public void success(T var1);

        public void error(@NonNull Throwable var1);
    }

    public static final class PigeonInitializeResponse {
        @NonNull
        private String name;
        @NonNull
        private PigeonFirebaseOptions options;
        @Nullable
        private Boolean isAutomaticDataCollectionEnabled;
        @NonNull
        private Map<String, Object> pluginConstants;

        @NonNull
        public String getName() {
            return this.name;
        }

        public void setName(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"name\" is null.");
            }
            this.name = setterArg;
        }

        @NonNull
        public PigeonFirebaseOptions getOptions() {
            return this.options;
        }

        public void setOptions(@NonNull PigeonFirebaseOptions setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"options\" is null.");
            }
            this.options = setterArg;
        }

        @Nullable
        public Boolean getIsAutomaticDataCollectionEnabled() {
            return this.isAutomaticDataCollectionEnabled;
        }

        public void setIsAutomaticDataCollectionEnabled(@Nullable Boolean setterArg) {
            this.isAutomaticDataCollectionEnabled = setterArg;
        }

        @NonNull
        public Map<String, Object> getPluginConstants() {
            return this.pluginConstants;
        }

        public void setPluginConstants(@NonNull Map<String, Object> setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"pluginConstants\" is null.");
            }
            this.pluginConstants = setterArg;
        }

        PigeonInitializeResponse() {
        }

        @NonNull
        public ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(4);
            toListResult.add(this.name);
            toListResult.add(this.options == null ? null : this.options.toList());
            toListResult.add(this.isAutomaticDataCollectionEnabled);
            toListResult.add(this.pluginConstants);
            return toListResult;
        }

        @NonNull
        static PigeonInitializeResponse fromList(@NonNull ArrayList<Object> list) {
            PigeonInitializeResponse pigeonResult = new PigeonInitializeResponse();
            Object name = list.get(0);
            pigeonResult.setName((String)name);
            Object options = list.get(1);
            pigeonResult.setOptions(options == null ? null : PigeonFirebaseOptions.fromList((ArrayList)options));
            Object isAutomaticDataCollectionEnabled = list.get(2);
            pigeonResult.setIsAutomaticDataCollectionEnabled((Boolean)isAutomaticDataCollectionEnabled);
            Object pluginConstants = list.get(3);
            pigeonResult.setPluginConstants((Map)pluginConstants);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String name;
            @Nullable
            private PigeonFirebaseOptions options;
            @Nullable
            private Boolean isAutomaticDataCollectionEnabled;
            @Nullable
            private Map<String, Object> pluginConstants;

            @NonNull
            public Builder setName(@NonNull String setterArg) {
                this.name = setterArg;
                return this;
            }

            @NonNull
            public Builder setOptions(@NonNull PigeonFirebaseOptions setterArg) {
                this.options = setterArg;
                return this;
            }

            @NonNull
            public Builder setIsAutomaticDataCollectionEnabled(@Nullable Boolean setterArg) {
                this.isAutomaticDataCollectionEnabled = setterArg;
                return this;
            }

            @NonNull
            public Builder setPluginConstants(@NonNull Map<String, Object> setterArg) {
                this.pluginConstants = setterArg;
                return this;
            }

            @NonNull
            public PigeonInitializeResponse build() {
                PigeonInitializeResponse pigeonReturn = new PigeonInitializeResponse();
                pigeonReturn.setName(this.name);
                pigeonReturn.setOptions(this.options);
                pigeonReturn.setIsAutomaticDataCollectionEnabled(this.isAutomaticDataCollectionEnabled);
                pigeonReturn.setPluginConstants(this.pluginConstants);
                return pigeonReturn;
            }
        }
    }

    public static final class PigeonFirebaseOptions {
        @NonNull
        private String apiKey;
        @NonNull
        private String appId;
        @NonNull
        private String messagingSenderId;
        @NonNull
        private String projectId;
        @Nullable
        private String authDomain;
        @Nullable
        private String databaseURL;
        @Nullable
        private String storageBucket;
        @Nullable
        private String measurementId;
        @Nullable
        private String trackingId;
        @Nullable
        private String deepLinkURLScheme;
        @Nullable
        private String androidClientId;
        @Nullable
        private String iosClientId;
        @Nullable
        private String iosBundleId;
        @Nullable
        private String appGroupId;

        @NonNull
        public String getApiKey() {
            return this.apiKey;
        }

        public void setApiKey(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"apiKey\" is null.");
            }
            this.apiKey = setterArg;
        }

        @NonNull
        public String getAppId() {
            return this.appId;
        }

        public void setAppId(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"appId\" is null.");
            }
            this.appId = setterArg;
        }

        @NonNull
        public String getMessagingSenderId() {
            return this.messagingSenderId;
        }

        public void setMessagingSenderId(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"messagingSenderId\" is null.");
            }
            this.messagingSenderId = setterArg;
        }

        @NonNull
        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"projectId\" is null.");
            }
            this.projectId = setterArg;
        }

        @Nullable
        public String getAuthDomain() {
            return this.authDomain;
        }

        public void setAuthDomain(@Nullable String setterArg) {
            this.authDomain = setterArg;
        }

        @Nullable
        public String getDatabaseURL() {
            return this.databaseURL;
        }

        public void setDatabaseURL(@Nullable String setterArg) {
            this.databaseURL = setterArg;
        }

        @Nullable
        public String getStorageBucket() {
            return this.storageBucket;
        }

        public void setStorageBucket(@Nullable String setterArg) {
            this.storageBucket = setterArg;
        }

        @Nullable
        public String getMeasurementId() {
            return this.measurementId;
        }

        public void setMeasurementId(@Nullable String setterArg) {
            this.measurementId = setterArg;
        }

        @Nullable
        public String getTrackingId() {
            return this.trackingId;
        }

        public void setTrackingId(@Nullable String setterArg) {
            this.trackingId = setterArg;
        }

        @Nullable
        public String getDeepLinkURLScheme() {
            return this.deepLinkURLScheme;
        }

        public void setDeepLinkURLScheme(@Nullable String setterArg) {
            this.deepLinkURLScheme = setterArg;
        }

        @Nullable
        public String getAndroidClientId() {
            return this.androidClientId;
        }

        public void setAndroidClientId(@Nullable String setterArg) {
            this.androidClientId = setterArg;
        }

        @Nullable
        public String getIosClientId() {
            return this.iosClientId;
        }

        public void setIosClientId(@Nullable String setterArg) {
            this.iosClientId = setterArg;
        }

        @Nullable
        public String getIosBundleId() {
            return this.iosBundleId;
        }

        public void setIosBundleId(@Nullable String setterArg) {
            this.iosBundleId = setterArg;
        }

        @Nullable
        public String getAppGroupId() {
            return this.appGroupId;
        }

        public void setAppGroupId(@Nullable String setterArg) {
            this.appGroupId = setterArg;
        }

        PigeonFirebaseOptions() {
        }

        @NonNull
        public ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(14);
            toListResult.add(this.apiKey);
            toListResult.add(this.appId);
            toListResult.add(this.messagingSenderId);
            toListResult.add(this.projectId);
            toListResult.add(this.authDomain);
            toListResult.add(this.databaseURL);
            toListResult.add(this.storageBucket);
            toListResult.add(this.measurementId);
            toListResult.add(this.trackingId);
            toListResult.add(this.deepLinkURLScheme);
            toListResult.add(this.androidClientId);
            toListResult.add(this.iosClientId);
            toListResult.add(this.iosBundleId);
            toListResult.add(this.appGroupId);
            return toListResult;
        }

        @NonNull
        static PigeonFirebaseOptions fromList(@NonNull ArrayList<Object> list) {
            PigeonFirebaseOptions pigeonResult = new PigeonFirebaseOptions();
            Object apiKey = list.get(0);
            pigeonResult.setApiKey((String)apiKey);
            Object appId = list.get(1);
            pigeonResult.setAppId((String)appId);
            Object messagingSenderId = list.get(2);
            pigeonResult.setMessagingSenderId((String)messagingSenderId);
            Object projectId = list.get(3);
            pigeonResult.setProjectId((String)projectId);
            Object authDomain = list.get(4);
            pigeonResult.setAuthDomain((String)authDomain);
            Object databaseURL = list.get(5);
            pigeonResult.setDatabaseURL((String)databaseURL);
            Object storageBucket = list.get(6);
            pigeonResult.setStorageBucket((String)storageBucket);
            Object measurementId = list.get(7);
            pigeonResult.setMeasurementId((String)measurementId);
            Object trackingId = list.get(8);
            pigeonResult.setTrackingId((String)trackingId);
            Object deepLinkURLScheme = list.get(9);
            pigeonResult.setDeepLinkURLScheme((String)deepLinkURLScheme);
            Object androidClientId = list.get(10);
            pigeonResult.setAndroidClientId((String)androidClientId);
            Object iosClientId = list.get(11);
            pigeonResult.setIosClientId((String)iosClientId);
            Object iosBundleId = list.get(12);
            pigeonResult.setIosBundleId((String)iosBundleId);
            Object appGroupId = list.get(13);
            pigeonResult.setAppGroupId((String)appGroupId);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String apiKey;
            @Nullable
            private String appId;
            @Nullable
            private String messagingSenderId;
            @Nullable
            private String projectId;
            @Nullable
            private String authDomain;
            @Nullable
            private String databaseURL;
            @Nullable
            private String storageBucket;
            @Nullable
            private String measurementId;
            @Nullable
            private String trackingId;
            @Nullable
            private String deepLinkURLScheme;
            @Nullable
            private String androidClientId;
            @Nullable
            private String iosClientId;
            @Nullable
            private String iosBundleId;
            @Nullable
            private String appGroupId;

            @NonNull
            public Builder setApiKey(@NonNull String setterArg) {
                this.apiKey = setterArg;
                return this;
            }

            @NonNull
            public Builder setAppId(@NonNull String setterArg) {
                this.appId = setterArg;
                return this;
            }

            @NonNull
            public Builder setMessagingSenderId(@NonNull String setterArg) {
                this.messagingSenderId = setterArg;
                return this;
            }

            @NonNull
            public Builder setProjectId(@NonNull String setterArg) {
                this.projectId = setterArg;
                return this;
            }

            @NonNull
            public Builder setAuthDomain(@Nullable String setterArg) {
                this.authDomain = setterArg;
                return this;
            }

            @NonNull
            public Builder setDatabaseURL(@Nullable String setterArg) {
                this.databaseURL = setterArg;
                return this;
            }

            @NonNull
            public Builder setStorageBucket(@Nullable String setterArg) {
                this.storageBucket = setterArg;
                return this;
            }

            @NonNull
            public Builder setMeasurementId(@Nullable String setterArg) {
                this.measurementId = setterArg;
                return this;
            }

            @NonNull
            public Builder setTrackingId(@Nullable String setterArg) {
                this.trackingId = setterArg;
                return this;
            }

            @NonNull
            public Builder setDeepLinkURLScheme(@Nullable String setterArg) {
                this.deepLinkURLScheme = setterArg;
                return this;
            }

            @NonNull
            public Builder setAndroidClientId(@Nullable String setterArg) {
                this.androidClientId = setterArg;
                return this;
            }

            @NonNull
            public Builder setIosClientId(@Nullable String setterArg) {
                this.iosClientId = setterArg;
                return this;
            }

            @NonNull
            public Builder setIosBundleId(@Nullable String setterArg) {
                this.iosBundleId = setterArg;
                return this;
            }

            @NonNull
            public Builder setAppGroupId(@Nullable String setterArg) {
                this.appGroupId = setterArg;
                return this;
            }

            @NonNull
            public PigeonFirebaseOptions build() {
                PigeonFirebaseOptions pigeonReturn = new PigeonFirebaseOptions();
                pigeonReturn.setApiKey(this.apiKey);
                pigeonReturn.setAppId(this.appId);
                pigeonReturn.setMessagingSenderId(this.messagingSenderId);
                pigeonReturn.setProjectId(this.projectId);
                pigeonReturn.setAuthDomain(this.authDomain);
                pigeonReturn.setDatabaseURL(this.databaseURL);
                pigeonReturn.setStorageBucket(this.storageBucket);
                pigeonReturn.setMeasurementId(this.measurementId);
                pigeonReturn.setTrackingId(this.trackingId);
                pigeonReturn.setDeepLinkURLScheme(this.deepLinkURLScheme);
                pigeonReturn.setAndroidClientId(this.androidClientId);
                pigeonReturn.setIosClientId(this.iosClientId);
                pigeonReturn.setIosBundleId(this.iosBundleId);
                pigeonReturn.setAppGroupId(this.appGroupId);
                return pigeonReturn;
            }
        }
    }
}

