/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.imagepicker;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import androidx.activity.result.PickVisualMediaRequest;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.app.ActivityCompat;
import androidx.core.content.FileProvider;
import io.flutter.plugin.common.PluginRegistry;
import io.flutter.plugins.imagepicker.FileUtils;
import io.flutter.plugins.imagepicker.ImagePickerCache;
import io.flutter.plugins.imagepicker.ImagePickerUtils;
import io.flutter.plugins.imagepicker.ImageResizer;
import io.flutter.plugins.imagepicker.Messages;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ImagePickerDelegate
implements PluginRegistry.ActivityResultListener,
PluginRegistry.RequestPermissionsResultListener {
    @VisibleForTesting
    static final int REQUEST_CODE_CHOOSE_IMAGE_FROM_GALLERY = 2342;
    @VisibleForTesting
    static final int REQUEST_CODE_TAKE_IMAGE_WITH_CAMERA = 2343;
    @VisibleForTesting
    static final int REQUEST_CAMERA_IMAGE_PERMISSION = 2345;
    @VisibleForTesting
    static final int REQUEST_CODE_CHOOSE_MULTI_IMAGE_FROM_GALLERY = 2346;
    @VisibleForTesting
    static final int REQUEST_CODE_CHOOSE_MEDIA_FROM_GALLERY = 2347;
    @VisibleForTesting
    static final int REQUEST_CODE_CHOOSE_VIDEO_FROM_GALLERY = 2352;
    @VisibleForTesting
    static final int REQUEST_CODE_TAKE_VIDEO_WITH_CAMERA = 2353;
    @VisibleForTesting
    static final int REQUEST_CAMERA_VIDEO_PERMISSION = 2355;
    @VisibleForTesting
    final String fileProviderName;
    @NonNull
    private final Activity activity;
    @NonNull
    private final ImageResizer imageResizer;
    @NonNull
    private final ImagePickerCache cache;
    private final PermissionManager permissionManager;
    private final FileUriResolver fileUriResolver;
    private final FileUtils fileUtils;
    private final ExecutorService executor;
    private CameraDevice cameraDevice;
    private Uri pendingCameraMediaUri;
    @Nullable
    private PendingCallState pendingCallState;
    private final Object pendingCallStateLock = new Object();

    public ImagePickerDelegate(final @NonNull Activity activity, @NonNull ImageResizer imageResizer, @NonNull ImagePickerCache cache) {
        this(activity, imageResizer, null, null, null, cache, new PermissionManager(){

            @Override
            public boolean isPermissionGranted(String permissionName) {
                return ActivityCompat.checkSelfPermission((Context)activity, (String)permissionName) == 0;
            }

            @Override
            public void askForPermission(String permissionName, int requestCode) {
                ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{permissionName}, (int)requestCode);
            }

            @Override
            public boolean needRequestCameraPermission() {
                return ImagePickerUtils.needRequestCameraPermission((Context)activity);
            }
        }, new FileUriResolver(){

            @Override
            public Uri resolveFileProviderUriForFile(String fileProviderName, File file) {
                return FileProvider.getUriForFile((Context)activity, (String)fileProviderName, (File)file);
            }

            @Override
            public void getFullImagePath(Uri imageUri, OnPathReadyListener listener) {
                MediaScannerConnection.scanFile((Context)activity, (String[])new String[]{imageUri != null ? imageUri.getPath() : ""}, null, (path, uri) -> listener.onPathReady(path));
            }
        }, new FileUtils(), Executors.newSingleThreadExecutor());
    }

    @VisibleForTesting
    ImagePickerDelegate(@NonNull Activity activity, @NonNull ImageResizer imageResizer, @Nullable Messages.ImageSelectionOptions pendingImageOptions, @Nullable Messages.VideoSelectionOptions pendingVideoOptions, @Nullable Messages.Result<List<String>> result, @NonNull ImagePickerCache cache, PermissionManager permissionManager, FileUriResolver fileUriResolver, FileUtils fileUtils, ExecutorService executor) {
        this.activity = activity;
        this.imageResizer = imageResizer;
        this.fileProviderName = activity.getPackageName() + ".flutter.image_provider";
        if (result != null) {
            this.pendingCallState = new PendingCallState(pendingImageOptions, pendingVideoOptions, result);
        }
        this.permissionManager = permissionManager;
        this.fileUriResolver = fileUriResolver;
        this.fileUtils = fileUtils;
        this.cache = cache;
        this.executor = executor;
    }

    void setCameraDevice(CameraDevice device) {
        this.cameraDevice = device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveStateBeforeResult() {
        Uri localPendingCameraMediaUri;
        Messages.ImageSelectionOptions localImageOptions;
        Object object = this.pendingCallStateLock;
        synchronized (object) {
            if (this.pendingCallState == null) {
                return;
            }
            localImageOptions = this.pendingCallState.imageOptions;
        }
        this.cache.saveType(localImageOptions != null ? ImagePickerCache.CacheType.IMAGE : ImagePickerCache.CacheType.VIDEO);
        if (localImageOptions != null) {
            this.cache.saveDimensionWithOutputOptions(localImageOptions);
        }
        if ((localPendingCameraMediaUri = this.pendingCameraMediaUri) != null) {
            this.cache.savePendingCameraMediaUriPath(localPendingCameraMediaUri);
        }
    }

    @Nullable
    Messages.CacheRetrievalResult retrieveLostImage() {
        Map<String, Object> cacheMap = this.cache.getCacheMap();
        if (cacheMap.isEmpty()) {
            return null;
        }
        Messages.CacheRetrievalResult.Builder result = new Messages.CacheRetrievalResult.Builder();
        Messages.CacheRetrievalType type = (Messages.CacheRetrievalType)((Object)cacheMap.get("type"));
        if (type != null) {
            result.setType(type);
        }
        result.setError((Messages.CacheRetrievalError)cacheMap.get("error"));
        ArrayList pathList = (ArrayList)cacheMap.get("pathList");
        if (pathList != null) {
            ArrayList<String> newPathList = new ArrayList<String>();
            for (String path : pathList) {
                Double maxWidth = (Double)cacheMap.get("maxWidth");
                Double maxHeight = (Double)cacheMap.get("maxHeight");
                Integer boxedImageQuality = (Integer)cacheMap.get("imageQuality");
                int imageQuality = boxedImageQuality == null ? 100 : boxedImageQuality;
                newPathList.add(this.imageResizer.resizeImageIfNeeded(path, maxWidth, maxHeight, imageQuality));
            }
            result.setPaths(newPathList);
        }
        this.cache.clear();
        return result.build();
    }

    public void chooseMediaFromGallery(@NonNull Messages.MediaSelectionOptions options, @NonNull Messages.GeneralOptions generalOptions, @NonNull Messages.Result<List<String>> result) {
        if (!this.setPendingOptionsAndResult(options.getImageSelectionOptions(), null, result)) {
            this.finishWithAlreadyActiveError(result);
            return;
        }
        this.launchPickMediaFromGalleryIntent(generalOptions);
    }

    private void launchPickMediaFromGalleryIntent(Messages.GeneralOptions generalOptions) {
        Intent pickMediaIntent;
        if (generalOptions.getUsePhotoPicker().booleanValue()) {
            if (generalOptions.getAllowMultiple().booleanValue()) {
                int limit = ImagePickerUtils.getLimitFromOption(generalOptions);
                pickMediaIntent = new ActivityResultContracts.PickMultipleVisualMedia(limit).createIntent((Context)this.activity, new PickVisualMediaRequest.Builder().setMediaType((ActivityResultContracts.PickVisualMedia.VisualMediaType)ActivityResultContracts.PickVisualMedia.ImageAndVideo.INSTANCE).build());
            } else {
                pickMediaIntent = new ActivityResultContracts.PickVisualMedia().createIntent((Context)this.activity, new PickVisualMediaRequest.Builder().setMediaType((ActivityResultContracts.PickVisualMedia.VisualMediaType)ActivityResultContracts.PickVisualMedia.ImageAndVideo.INSTANCE).build());
            }
        } else {
            pickMediaIntent = new Intent("android.intent.action.GET_CONTENT");
            pickMediaIntent.setType("*/*");
            String[] mimeTypes = new String[]{"video/*", "image/*"};
            pickMediaIntent.putExtra("CONTENT_TYPE", mimeTypes);
            pickMediaIntent.putExtra("android.intent.extra.ALLOW_MULTIPLE", (Serializable)generalOptions.getAllowMultiple());
        }
        this.activity.startActivityForResult(pickMediaIntent, 2347);
    }

    public void chooseVideoFromGallery(@NonNull Messages.VideoSelectionOptions options, boolean usePhotoPicker, @NonNull Messages.Result<List<String>> result) {
        if (!this.setPendingOptionsAndResult(null, options, result)) {
            this.finishWithAlreadyActiveError(result);
            return;
        }
        this.launchPickVideoFromGalleryIntent(usePhotoPicker);
    }

    private void launchPickVideoFromGalleryIntent(Boolean usePhotoPicker) {
        Intent pickVideoIntent;
        if (usePhotoPicker.booleanValue()) {
            pickVideoIntent = new ActivityResultContracts.PickVisualMedia().createIntent((Context)this.activity, new PickVisualMediaRequest.Builder().setMediaType((ActivityResultContracts.PickVisualMedia.VisualMediaType)ActivityResultContracts.PickVisualMedia.VideoOnly.INSTANCE).build());
        } else {
            pickVideoIntent = new Intent("android.intent.action.GET_CONTENT");
            pickVideoIntent.setType("video/*");
        }
        this.activity.startActivityForResult(pickVideoIntent, 2352);
    }

    public void takeVideoWithCamera(@NonNull Messages.VideoSelectionOptions options, @NonNull Messages.Result<List<String>> result) {
        if (!this.setPendingOptionsAndResult(null, options, result)) {
            this.finishWithAlreadyActiveError(result);
            return;
        }
        if (this.needRequestCameraPermission() && !this.permissionManager.isPermissionGranted("android.permission.CAMERA")) {
            this.permissionManager.askForPermission("android.permission.CAMERA", 2355);
            return;
        }
        this.launchTakeVideoWithCameraIntent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launchTakeVideoWithCameraIntent() {
        Intent intent = new Intent("android.media.action.VIDEO_CAPTURE");
        Messages.VideoSelectionOptions localVideoOptions = null;
        Object object = this.pendingCallStateLock;
        synchronized (object) {
            if (this.pendingCallState != null) {
                localVideoOptions = this.pendingCallState.videoOptions;
            }
        }
        if (localVideoOptions != null && localVideoOptions.getMaxDurationSeconds() != null) {
            int maxSeconds = localVideoOptions.getMaxDurationSeconds().intValue();
            intent.putExtra("android.intent.extra.durationLimit", maxSeconds);
        }
        if (this.cameraDevice == CameraDevice.FRONT) {
            this.useFrontCamera(intent);
        }
        File videoFile = this.createTemporaryWritableVideoFile();
        this.pendingCameraMediaUri = Uri.parse((String)("file:" + videoFile.getAbsolutePath()));
        Uri videoUri = this.fileUriResolver.resolveFileProviderUriForFile(this.fileProviderName, videoFile);
        intent.putExtra("output", (Parcelable)videoUri);
        this.grantUriPermissions(intent, videoUri);
        try {
            this.activity.startActivityForResult(intent, 2353);
        }
        catch (ActivityNotFoundException e) {
            try {
                videoFile.delete();
            }
            catch (SecurityException exception) {
                exception.printStackTrace();
            }
            this.finishWithError("no_available_camera", "No cameras available for taking pictures.");
        }
    }

    public void chooseImageFromGallery(@NonNull Messages.ImageSelectionOptions options, boolean usePhotoPicker, @NonNull Messages.Result<List<String>> result) {
        if (!this.setPendingOptionsAndResult(options, null, result)) {
            this.finishWithAlreadyActiveError(result);
            return;
        }
        this.launchPickImageFromGalleryIntent(usePhotoPicker);
    }

    public void chooseMultiImageFromGallery(@NonNull Messages.ImageSelectionOptions options, boolean usePhotoPicker, int limit, @NonNull Messages.Result<List<String>> result) {
        if (!this.setPendingOptionsAndResult(options, null, result)) {
            this.finishWithAlreadyActiveError(result);
            return;
        }
        this.launchMultiPickImageFromGalleryIntent(usePhotoPicker, limit);
    }

    private void launchPickImageFromGalleryIntent(Boolean usePhotoPicker) {
        Intent pickImageIntent;
        if (usePhotoPicker.booleanValue()) {
            pickImageIntent = new ActivityResultContracts.PickVisualMedia().createIntent((Context)this.activity, new PickVisualMediaRequest.Builder().setMediaType((ActivityResultContracts.PickVisualMedia.VisualMediaType)ActivityResultContracts.PickVisualMedia.ImageOnly.INSTANCE).build());
        } else {
            pickImageIntent = new Intent("android.intent.action.GET_CONTENT");
            pickImageIntent.setType("image/*");
        }
        this.activity.startActivityForResult(pickImageIntent, 2342);
    }

    private void launchMultiPickImageFromGalleryIntent(Boolean usePhotoPicker, int limit) {
        Intent pickMultiImageIntent;
        if (usePhotoPicker.booleanValue()) {
            pickMultiImageIntent = new ActivityResultContracts.PickMultipleVisualMedia(limit).createIntent((Context)this.activity, new PickVisualMediaRequest.Builder().setMediaType((ActivityResultContracts.PickVisualMedia.VisualMediaType)ActivityResultContracts.PickVisualMedia.ImageOnly.INSTANCE).build());
        } else {
            pickMultiImageIntent = new Intent("android.intent.action.GET_CONTENT");
            pickMultiImageIntent.setType("image/*");
            pickMultiImageIntent.putExtra("android.intent.extra.ALLOW_MULTIPLE", true);
        }
        this.activity.startActivityForResult(pickMultiImageIntent, 2346);
    }

    public void takeImageWithCamera(@NonNull Messages.ImageSelectionOptions options, @NonNull Messages.Result<List<String>> result) {
        if (!this.setPendingOptionsAndResult(options, null, result)) {
            this.finishWithAlreadyActiveError(result);
            return;
        }
        if (this.needRequestCameraPermission() && !this.permissionManager.isPermissionGranted("android.permission.CAMERA")) {
            this.permissionManager.askForPermission("android.permission.CAMERA", 2345);
            return;
        }
        this.launchTakeImageWithCameraIntent();
    }

    private boolean needRequestCameraPermission() {
        if (this.permissionManager == null) {
            return false;
        }
        return this.permissionManager.needRequestCameraPermission();
    }

    private void launchTakeImageWithCameraIntent() {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (this.cameraDevice == CameraDevice.FRONT) {
            this.useFrontCamera(intent);
        }
        File imageFile = this.createTemporaryWritableImageFile();
        this.pendingCameraMediaUri = Uri.parse((String)("file:" + imageFile.getAbsolutePath()));
        Uri imageUri = this.fileUriResolver.resolveFileProviderUriForFile(this.fileProviderName, imageFile);
        intent.putExtra("output", (Parcelable)imageUri);
        this.grantUriPermissions(intent, imageUri);
        try {
            this.activity.startActivityForResult(intent, 2343);
        }
        catch (ActivityNotFoundException e) {
            try {
                imageFile.delete();
            }
            catch (SecurityException exception) {
                exception.printStackTrace();
            }
            this.finishWithError("no_available_camera", "No cameras available for taking pictures.");
        }
    }

    private File createTemporaryWritableImageFile() {
        return this.createTemporaryWritableFile(".jpg");
    }

    private File createTemporaryWritableVideoFile() {
        return this.createTemporaryWritableFile(".mp4");
    }

    private File createTemporaryWritableFile(String suffix) {
        File image;
        String filename = UUID.randomUUID().toString();
        File externalFilesDirectory = this.activity.getCacheDir();
        try {
            externalFilesDirectory.mkdirs();
            image = File.createTempFile(filename, suffix, externalFilesDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return image;
    }

    private void grantUriPermissions(Intent intent, Uri imageUri) {
        PackageManager packageManager = this.activity.getPackageManager();
        List compatibleActivities = Build.VERSION.SDK_INT >= 33 ? packageManager.queryIntentActivities(intent, PackageManager.ResolveInfoFlags.of((long)65536L)) : ImagePickerDelegate.queryIntentActivitiesPreApi33(packageManager, intent);
        for (ResolveInfo info : compatibleActivities) {
            this.activity.grantUriPermission(info.activityInfo.packageName, imageUri, 3);
        }
    }

    private static List<ResolveInfo> queryIntentActivitiesPreApi33(PackageManager packageManager, Intent intent) {
        return packageManager.queryIntentActivities(intent, 65536);
    }

    public boolean onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        boolean permissionGranted = grantResults.length > 0 && grantResults[0] == 0;
        switch (requestCode) {
            case 2345: {
                if (!permissionGranted) break;
                this.launchTakeImageWithCameraIntent();
                break;
            }
            case 2355: {
                if (!permissionGranted) break;
                this.launchTakeVideoWithCameraIntent();
                break;
            }
            default: {
                return false;
            }
        }
        if (!permissionGranted) {
            switch (requestCode) {
                case 2345: 
                case 2355: {
                    this.finishWithError("camera_access_denied", "The user did not allow camera access.");
                }
            }
        }
        return true;
    }

    public boolean onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        Runnable handlerRunnable;
        switch (requestCode) {
            case 2342: {
                handlerRunnable = () -> this.handleChooseImageResult(resultCode, data);
                break;
            }
            case 2346: {
                handlerRunnable = () -> this.handleChooseMultiImageResult(resultCode, data);
                break;
            }
            case 2343: {
                handlerRunnable = () -> this.handleCaptureImageResult(resultCode);
                break;
            }
            case 2347: {
                handlerRunnable = () -> this.handleChooseMediaResult(resultCode, data);
                break;
            }
            case 2352: {
                handlerRunnable = () -> this.handleChooseVideoResult(resultCode, data);
                break;
            }
            case 2353: {
                handlerRunnable = () -> this.handleCaptureVideoResult(resultCode);
                break;
            }
            default: {
                return false;
            }
        }
        this.executor.execute(handlerRunnable);
        return true;
    }

    @Nullable
    private ArrayList<MediaPath> getPathsFromIntent(@NonNull Intent data, boolean includeMimeType) {
        ArrayList<MediaPath> paths = new ArrayList<MediaPath>();
        Uri uri = data.getData();
        if (uri == null) {
            ClipData clipData = data.getClipData();
            if (clipData == null) {
                return null;
            }
            for (int i = 0; i < data.getClipData().getItemCount(); ++i) {
                uri = data.getClipData().getItemAt(i).getUri();
                if (uri == null) {
                    return null;
                }
                String path = this.fileUtils.getPathFromUri((Context)this.activity, uri);
                if (path == null) {
                    return null;
                }
                String mimeType = includeMimeType ? this.activity.getContentResolver().getType(uri) : null;
                paths.add(new MediaPath(path, mimeType));
            }
        } else {
            String path = this.fileUtils.getPathFromUri((Context)this.activity, uri);
            if (path == null) {
                return null;
            }
            paths.add(new MediaPath(path, null));
        }
        return paths;
    }

    private void handleChooseImageResult(int resultCode, Intent data) {
        if (resultCode == -1 && data != null) {
            ArrayList<MediaPath> paths = this.getPathsFromIntent(data, false);
            if (paths == null) {
                this.finishWithError("no_valid_image_uri", "Cannot find the selected image.");
                return;
            }
            this.handleMediaResult(paths);
            return;
        }
        this.finishWithSuccess(null);
    }

    private void handleChooseMediaResult(int resultCode, Intent intent) {
        if (resultCode == -1 && intent != null) {
            ArrayList<MediaPath> paths = this.getPathsFromIntent(intent, true);
            if (paths == null) {
                this.finishWithError("no_valid_media_uri", "Cannot find the selected media.");
                return;
            }
            this.handleMediaResult(paths);
            return;
        }
        this.finishWithSuccess(null);
    }

    private void handleChooseMultiImageResult(int resultCode, Intent intent) {
        if (resultCode == -1 && intent != null) {
            ArrayList<MediaPath> paths = this.getPathsFromIntent(intent, false);
            if (paths == null) {
                this.finishWithError("missing_valid_image_uri", "Cannot find at least one of the selected images.");
                return;
            }
            this.handleMediaResult(paths);
            return;
        }
        this.finishWithSuccess(null);
    }

    private void handleChooseVideoResult(int resultCode, Intent data) {
        if (resultCode == -1 && data != null) {
            ArrayList<MediaPath> paths = this.getPathsFromIntent(data, false);
            if (paths == null || paths.size() < 1) {
                this.finishWithError("no_valid_video_uri", "Cannot find the selected video.");
                return;
            }
            this.finishWithSuccess(paths.get((int)0).path);
            return;
        }
        this.finishWithSuccess(null);
    }

    private void handleCaptureImageResult(int resultCode) {
        if (resultCode == -1) {
            Uri localPendingCameraMediaUri = this.pendingCameraMediaUri;
            this.fileUriResolver.getFullImagePath(localPendingCameraMediaUri != null ? localPendingCameraMediaUri : Uri.parse((String)this.cache.retrievePendingCameraMediaUriPath()), path -> this.handleImageResult(path, true));
            return;
        }
        this.finishWithSuccess(null);
    }

    private void handleCaptureVideoResult(int resultCode) {
        if (resultCode == -1) {
            Uri localPendingCameraMediaUrl = this.pendingCameraMediaUri;
            this.fileUriResolver.getFullImagePath(localPendingCameraMediaUrl != null ? localPendingCameraMediaUrl : Uri.parse((String)this.cache.retrievePendingCameraMediaUriPath()), this::finishWithSuccess);
            return;
        }
        this.finishWithSuccess(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleImageResult(String path, boolean shouldDeleteOriginalIfScaled) {
        Messages.ImageSelectionOptions localImageOptions = null;
        Object object = this.pendingCallStateLock;
        synchronized (object) {
            if (this.pendingCallState != null) {
                localImageOptions = this.pendingCallState.imageOptions;
            }
        }
        if (localImageOptions != null) {
            String finalImagePath = this.getResizedImagePath(path, localImageOptions);
            if (finalImagePath != null && !finalImagePath.equals(path) && shouldDeleteOriginalIfScaled) {
                new File(path).delete();
            }
            this.finishWithSuccess(finalImagePath);
        } else {
            this.finishWithSuccess(path);
        }
    }

    private String getResizedImagePath(String path, @NonNull Messages.ImageSelectionOptions outputOptions) {
        return this.imageResizer.resizeImageIfNeeded(path, outputOptions.getMaxWidth(), outputOptions.getMaxHeight(), outputOptions.getQuality().intValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMediaResult(@NonNull ArrayList<MediaPath> paths) {
        Messages.ImageSelectionOptions localImageOptions = null;
        Object object = this.pendingCallStateLock;
        synchronized (object) {
            if (this.pendingCallState != null) {
                localImageOptions = this.pendingCallState.imageOptions;
            }
        }
        ArrayList<String> finalPaths = new ArrayList<String>();
        if (localImageOptions != null) {
            for (int i = 0; i < paths.size(); ++i) {
                MediaPath path = paths.get(i);
                String finalPath = path.path;
                if (path.mimeType == null || !path.mimeType.startsWith("video/")) {
                    finalPath = this.getResizedImagePath(path.path, localImageOptions);
                }
                finalPaths.add(finalPath);
            }
            this.finishWithListSuccess(finalPaths);
        } else {
            for (int i = 0; i < paths.size(); ++i) {
                finalPaths.add(paths.get((int)i).path);
            }
            this.finishWithListSuccess(finalPaths);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setPendingOptionsAndResult(@Nullable Messages.ImageSelectionOptions imageOptions, @Nullable Messages.VideoSelectionOptions videoOptions, @NonNull Messages.Result<List<String>> result) {
        Object object = this.pendingCallStateLock;
        synchronized (object) {
            if (this.pendingCallState != null) {
                return false;
            }
            this.pendingCallState = new PendingCallState(imageOptions, videoOptions, result);
        }
        this.cache.clear();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishWithSuccess(@Nullable String imagePath) {
        ArrayList<String> pathList = new ArrayList<String>();
        if (imagePath != null) {
            pathList.add(imagePath);
        }
        Messages.Result<List<String>> localResult = null;
        Object object = this.pendingCallStateLock;
        synchronized (object) {
            if (this.pendingCallState != null) {
                localResult = this.pendingCallState.result;
            }
            this.pendingCallState = null;
        }
        if (localResult == null) {
            if (!pathList.isEmpty()) {
                this.cache.saveResult(pathList, null, null);
            }
        } else {
            localResult.success(pathList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishWithListSuccess(ArrayList<String> imagePaths) {
        Messages.Result<List<String>> localResult = null;
        Object object = this.pendingCallStateLock;
        synchronized (object) {
            if (this.pendingCallState != null) {
                localResult = this.pendingCallState.result;
            }
            this.pendingCallState = null;
        }
        if (localResult == null) {
            this.cache.saveResult(imagePaths, null, null);
        } else {
            localResult.success(imagePaths);
        }
    }

    private void finishWithAlreadyActiveError(Messages.Result<List<String>> result) {
        result.error(new Messages.FlutterError("already_active", "Image picker is already active", null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishWithError(String errorCode, String errorMessage) {
        Messages.Result<List<String>> localResult = null;
        Object object = this.pendingCallStateLock;
        synchronized (object) {
            if (this.pendingCallState != null) {
                localResult = this.pendingCallState.result;
            }
            this.pendingCallState = null;
        }
        if (localResult == null) {
            this.cache.saveResult(null, errorCode, errorMessage);
        } else {
            localResult.error(new Messages.FlutterError(errorCode, errorMessage, null));
        }
    }

    private void useFrontCamera(Intent intent) {
        if (Build.VERSION.SDK_INT >= 22) {
            intent.putExtra("android.intent.extras.CAMERA_FACING", 0);
            if (Build.VERSION.SDK_INT >= 26) {
                intent.putExtra("android.intent.extra.USE_FRONT_CAMERA", true);
            }
        } else {
            intent.putExtra("android.intent.extras.CAMERA_FACING", 1);
        }
    }

    static interface PermissionManager {
        public boolean isPermissionGranted(String var1);

        public void askForPermission(String var1, int var2);

        public boolean needRequestCameraPermission();
    }

    static interface FileUriResolver {
        public Uri resolveFileProviderUriForFile(String var1, File var2);

        public void getFullImagePath(Uri var1, OnPathReadyListener var2);
    }

    private static class PendingCallState {
        @Nullable
        public final Messages.ImageSelectionOptions imageOptions;
        @Nullable
        public final Messages.VideoSelectionOptions videoOptions;
        @NonNull
        public final Messages.Result<List<String>> result;

        PendingCallState(@Nullable Messages.ImageSelectionOptions imageOptions, @Nullable Messages.VideoSelectionOptions videoOptions, @NonNull Messages.Result<List<String>> result) {
            this.imageOptions = imageOptions;
            this.videoOptions = videoOptions;
            this.result = result;
        }
    }

    public static enum CameraDevice {
        REAR,
        FRONT;

    }

    public class MediaPath {
        final String path;
        final String mimeType;

        public MediaPath(@Nullable String path, String mimeType) {
            this.path = path;
            this.mimeType = mimeType;
        }

        @NonNull
        public String getPath() {
            return this.path;
        }

        @Nullable
        public String getMimeType() {
            return this.mimeType;
        }
    }

    static interface OnPathReadyListener {
        public void onPathReady(String var1);
    }
}

