/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.appcheck;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.appcheck.AppCheckProviderFactory;
import com.google.firebase.appcheck.AppCheckToken;
import com.google.firebase.appcheck.FirebaseAppCheck;
import com.google.firebase.appcheck.debug.DebugAppCheckProviderFactory;
import com.google.firebase.appcheck.playintegrity.PlayIntegrityAppCheckProviderFactory;
import com.google.firebase.appcheck.safetynet.SafetyNetAppCheckProviderFactory;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.EventChannel;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugins.firebase.appcheck.TokenChannelStreamHandler;
import io.flutter.plugins.firebase.core.FlutterFirebasePlugin;
import io.flutter.plugins.firebase.core.FlutterFirebasePluginRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class FlutterFirebaseAppCheckPlugin
implements FlutterFirebasePlugin,
FlutterPlugin,
MethodChannel.MethodCallHandler {
    private static final String METHOD_CHANNEL_NAME = "plugins.flutter.io/firebase_app_check";
    private final Map<EventChannel, TokenChannelStreamHandler> streamHandlers = new HashMap<EventChannel, TokenChannelStreamHandler>();
    private final String debugProvider = "debug";
    private final String safetyNetProvider = "safetyNet";
    private final String playIntegrity = "playIntegrity";
    @Nullable
    private BinaryMessenger messenger;
    private MethodChannel channel;

    private void initInstance(BinaryMessenger messenger) {
        FlutterFirebasePluginRegistry.registerPlugin((String)METHOD_CHANNEL_NAME, (FlutterFirebasePlugin)this);
        this.channel = new MethodChannel(messenger, METHOD_CHANNEL_NAME);
        this.channel.setMethodCallHandler((MethodChannel.MethodCallHandler)this);
        this.messenger = messenger;
    }

    public void onAttachedToEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        this.initInstance(binding.getBinaryMessenger());
    }

    public void onDetachedFromEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        this.channel.setMethodCallHandler(null);
        this.channel = null;
        this.messenger = null;
        this.removeEventListeners();
    }

    private FirebaseAppCheck getAppCheck(Map<String, Object> arguments) {
        String appName = (String)Objects.requireNonNull(arguments.get("appName"));
        FirebaseApp app = FirebaseApp.getInstance((String)appName);
        return FirebaseAppCheck.getInstance((FirebaseApp)app);
    }

    private Task<String> getLimitedUseAppCheckToken(Map<String, Object> arguments) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        cachedThreadPool.execute(() -> {
            try {
                FirebaseAppCheck firebaseAppCheck = this.getAppCheck(arguments);
                AppCheckToken tokenResult = (AppCheckToken)Tasks.await((Task)firebaseAppCheck.getLimitedUseAppCheckToken());
                taskCompletionSource.setResult((Object)tokenResult.getToken());
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        return taskCompletionSource.getTask();
    }

    private Task<Void> activate(Map<String, Object> arguments) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        cachedThreadPool.execute(() -> {
            try {
                String provider;
                switch (provider = (String)Objects.requireNonNull(arguments.get("androidProvider"))) {
                    case "debug": {
                        FirebaseAppCheck firebaseAppCheck = this.getAppCheck(arguments);
                        firebaseAppCheck.installAppCheckProviderFactory((AppCheckProviderFactory)DebugAppCheckProviderFactory.getInstance());
                        break;
                    }
                    case "safetyNet": {
                        FirebaseAppCheck firebaseAppCheck = this.getAppCheck(arguments);
                        firebaseAppCheck.installAppCheckProviderFactory((AppCheckProviderFactory)SafetyNetAppCheckProviderFactory.getInstance());
                        break;
                    }
                    case "playIntegrity": {
                        FirebaseAppCheck firebaseAppCheck = this.getAppCheck(arguments);
                        firebaseAppCheck.installAppCheckProviderFactory((AppCheckProviderFactory)PlayIntegrityAppCheckProviderFactory.getInstance());
                        break;
                    }
                }
                taskCompletionSource.setResult(null);
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        return taskCompletionSource.getTask();
    }

    private Task<String> getToken(Map<String, Object> arguments) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        cachedThreadPool.execute(() -> {
            try {
                FirebaseAppCheck firebaseAppCheck = this.getAppCheck(arguments);
                Boolean forceRefresh = (Boolean)Objects.requireNonNull(arguments.get("forceRefresh"));
                AppCheckToken tokenResult = (AppCheckToken)Tasks.await((Task)firebaseAppCheck.getAppCheckToken(forceRefresh.booleanValue()));
                taskCompletionSource.setResult((Object)tokenResult.getToken());
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        return taskCompletionSource.getTask();
    }

    private Task<Void> setTokenAutoRefreshEnabled(Map<String, Object> arguments) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        cachedThreadPool.execute(() -> {
            try {
                FirebaseAppCheck firebaseAppCheck = this.getAppCheck(arguments);
                Boolean isTokenAutoRefreshEnabled = (Boolean)Objects.requireNonNull(arguments.get("isTokenAutoRefreshEnabled"));
                firebaseAppCheck.setTokenAutoRefreshEnabled(isTokenAutoRefreshEnabled.booleanValue());
                taskCompletionSource.setResult(null);
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        return taskCompletionSource.getTask();
    }

    private Task<String> registerTokenListener(Map<String, Object> arguments) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        cachedThreadPool.execute(() -> {
            try {
                String appName = (String)Objects.requireNonNull(arguments.get("appName"));
                FirebaseAppCheck firebaseAppCheck = this.getAppCheck(arguments);
                TokenChannelStreamHandler handler = new TokenChannelStreamHandler(firebaseAppCheck);
                String name = "plugins.flutter.io/firebase_app_check/token/" + appName;
                EventChannel channel = new EventChannel(this.messenger, name);
                channel.setStreamHandler((EventChannel.StreamHandler)handler);
                this.streamHandlers.put(channel, handler);
                taskCompletionSource.setResult((Object)name);
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        return taskCompletionSource.getTask();
    }

    public void onMethodCall(MethodCall call, @NonNull MethodChannel.Result result) {
        Object methodCallTask;
        switch (call.method) {
            case "FirebaseAppCheck#activate": {
                methodCallTask = this.activate((Map)call.arguments());
                break;
            }
            case "FirebaseAppCheck#getToken": {
                methodCallTask = this.getToken((Map)call.arguments());
                break;
            }
            case "FirebaseAppCheck#setTokenAutoRefreshEnabled": {
                methodCallTask = this.setTokenAutoRefreshEnabled((Map)call.arguments());
                break;
            }
            case "FirebaseAppCheck#registerTokenListener": {
                methodCallTask = this.registerTokenListener((Map)call.arguments());
                break;
            }
            case "FirebaseAppCheck#getLimitedUseAppCheckToken": {
                methodCallTask = this.getLimitedUseAppCheckToken((Map)call.arguments());
                break;
            }
            default: {
                result.notImplemented();
                return;
            }
        }
        methodCallTask.addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                result.success(task.getResult());
            } else {
                Exception exception = task.getException();
                result.error("firebase_app_check", exception != null ? exception.getMessage() : null, this.getExceptionDetails(exception));
            }
        });
    }

    private Map<String, Object> getExceptionDetails(@Nullable Exception exception) {
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("code", "unknown");
        if (exception != null) {
            details.put("message", exception.getMessage());
        } else {
            details.put("message", "An unknown error has occurred.");
        }
        return details;
    }

    public Task<Map<String, Object>> getPluginConstantsForFirebaseApp(FirebaseApp firebaseApp) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        cachedThreadPool.execute(() -> {
            try {
                taskCompletionSource.setResult(null);
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        return taskCompletionSource.getTask();
    }

    public Task<Void> didReinitializeFirebaseCore() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        cachedThreadPool.execute(() -> {
            try {
                taskCompletionSource.setResult(null);
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        return taskCompletionSource.getTask();
    }

    private void removeEventListeners() {
        for (EventChannel eventChannel : this.streamHandlers.keySet()) {
            EventChannel.StreamHandler streamHandler = this.streamHandlers.get(eventChannel);
            assert (streamHandler != null);
            streamHandler.onCancel(null);
            eventChannel.setStreamHandler(null);
        }
        this.streamHandlers.clear();
    }
}

